/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Nfdynm2AtomCoords;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.mainpanel.DefaultInternalFrameChase;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class DynmDiffPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)DynmDiffPanel.class.getName());
    private String fromFile = "";
    private String toFile = "";
    private int toIndex = -1;
    private int fromIndex = 0;
    private FileChooser from;
    private FileChooser to;

    public DynmDiffPanel() {
        this("", "");
    }

    public DynmDiffPanel(String fromFile) {
        this(fromFile, "");
    }

    public DynmDiffPanel(String fromFile, String toFile) {
        super("compare two F_DYNM files", true, true, true, true, new Dimension(350, 200));
        this.fromFile = fromFile;
        this.toFile = toFile;
        this.init();
    }

    public DynmDiffPanel(String fromFile, String toFile, int fromIndex, int toIndex) {
        super("compare two F_DYNM files", true, true, true, true, new Dimension(350, 200));
        this.fromFile = fromFile;
        this.toFile = toFile;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.init();
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.from = new FileChooser("from", this.fromFile, String.valueOf(this.fromIndex));
        this.to = new FileChooser("to", this.toFile, String.valueOf(this.toIndex));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.add(this.from);
        p1.add(this.to);
        container.add((Component)p1, "North");
        JButton ok = new JButton("ok");
        JButton can = new JButton("cancel");
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.add(ok);
        p2.add(can);
        JPanel pp = new JPanel();
        pp.add(p2);
        container.add((Component)pp, "South");
        can.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DynmDiffPanel.this.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DynmDiffPanel.this.doIt();
            }
        });
    }

    private void doIt() {
        String fromFile = this.from.getFileName();
        String toFile = this.to.getFileName();
        int fromFrame = this.from.getFrameNum();
        int toFrame = this.to.getFrameNum();
        Nfdynm2AtomCoords fromParser = new Nfdynm2AtomCoords(fromFile);
        Nfdynm2AtomCoords toParser = new Nfdynm2AtomCoords(toFile);
        AtomCoords fromCoords = null;
        AtomCoords toCoords = null;
        fromCoords = fromParser.getFrameAt(fromFrame);
        toCoords = toParser.getFrameAt(toFrame);
        fromCoords.isCart(true);
        toCoords.isCart(true);
        fromCoords.convert(7, 8);
        toCoords.convert(7, 8);
        AtomList fromList = fromCoords.getAtomList();
        AtomList toList = toCoords.getAtomList();
        double[][] fromCell = fromCoords.getCellDouble(0);
        double[][] toCell = fromCoords.getCellDouble(0);
        int i = 0;
        while (i < 3) {
            this.logger.debug((Object)("from cell : " + fromCell[i][0] + " " + fromCell[i][1] + " " + fromCell[i][2]));
            this.logger.debug((Object)("to cell : " + toCell[i][0] + " " + toCell[i][1] + " " + toCell[i][2]));
            ++i;
        }
        i = 0;
        while (i < fromList.size()) {
            this.logger.debug((Object)("from atom, no. " + i + ": " + fromList.getAtomAt(i)));
            ++i;
        }
        i = 0;
        while (i < toList.size()) {
            this.logger.debug((Object)("to atom, no. " + i + ": " + toList.getAtomAt(i)));
            ++i;
        }
        int numcomp = fromList.size();
        if (numcomp > toList.size()) {
            numcomp = toList.size();
        }
        double cellxh = 0.5;
        double cellyh = 0.5;
        double cellzh = 0.5;
        String LS = System.getProperty("line.separator");
        String result = "#units : Angstrom" + LS;
        result = String.valueOf(result) + "#index element \u0394x \u0394y \u0394z \u0394d" + LS;
        DecimalFormat format = ConstParameters.formater_smaller_digits;
        int i2 = 0;
        while (i2 < numcomp) {
            double[] fromPos = fromList.getAtomAt(i2).getDouble();
            double[] toPos = toList.getAtomAt(i2).getDouble();
            double diffx = fromPos[0] - toPos[0];
            double diffy = fromPos[1] - toPos[1];
            double diffz = fromPos[2] - toPos[2];
            if (diffx > cellxh) {
                diffx -= cellxh;
            } else if (diffx < -cellxh) {
                diffx += cellxh;
            }
            if (diffy > cellyh) {
                diffy -= cellyh;
            } else if (diffy < -cellyh) {
                diffy += cellyh;
            }
            if (diffz > cellzh) {
                diffz -= cellzh;
            } else if (diffz < -cellzh) {
                diffz += cellzh;
            }
            double x = toCell[0][0] * diffx + toCell[1][0] * diffy + toCell[2][0] * diffz;
            double y = toCell[0][1] * diffx + toCell[1][1] * diffy + toCell[2][1] * diffz;
            double z = toCell[0][2] * diffx + toCell[1][2] * diffy + toCell[2][2] * diffz;
            result = String.valueOf(result) + Integer.toString(i2 + 1) + " " + fromList.getAtomAt(i2).getElementName() + " " + format.format(x) + " " + format.format(y) + " " + format.format(z) + " " + format.format(Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0))) + LS;
            ++i2;
        }
        JTextPane pane = new JTextPane();
        pane.setText(result);
        JScrollPane scrpane = new JScrollPane(pane);
        DefaultInternalFrameChase def = new DefaultInternalFrameChase("result", new Dimension(300, 500));
        def.getContentPane().add(scrpane);
    }

    class FileChooser
    extends JPanel {
        private JTextField textField;
        private JTextField frameNum;
        private JButton chooser;
        private String initFile = "";
        private String index = "0";

        FileChooser(String title, String initFile, String index) {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new TitledBorder(title));
            this.initFile = initFile;
            this.index = index;
            this.ini();
        }

        private void ini() {
            this.textField = new JTextField(10);
            this.textField.setText(this.initFile);
            this.frameNum = new JTextField(5);
            this.frameNum.setText(this.index);
            this.chooser = new JButton("choose");
            this.add(this.textField);
            this.add(this.frameNum);
            this.add(this.chooser);
            this.chooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    FileChooser.this.bootChooser();
                }
            });
        }

        private int getFrameNum() {
            int ret = 0;
            try {
                ret = Integer.parseInt(this.frameNum.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        private String getFileName() {
            return this.textField.getText();
        }

        private void bootChooser() {
            ChaseFileChooser chooser = new ChaseFileChooser("atom", true);
            chooser.setFileSelectionMode(0);
            if (chooser.showDialog(this, "select F_DYNM file") != 0) {
                DynmDiffPanel.this.logger.info((Object)"canceled");
                return;
            }
            String selected = chooser.getSelectedFile().getAbsolutePath();
            this.textField.setText(selected);
        }
    }
}

