/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.ExternalProgramPanel;
import ciss.phase_viewer.common.Utils;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class AnimDynmPlPanel
extends ExternalProgramPanel {
    private Logger logger = Logger.getLogger((String)AnimDynmPlPanel.class.getName());
    private String modeData;
    private String scriptName = "animate.pl";
    private String[] comp = new String[]{"mode_\\d+.tr2", "grid.mol2"};
    private JTextField origx;
    private JTextField origy;
    private JTextField origz;
    private JTextField vec1x;
    private JTextField vec1y;
    private JTextField vec1z;
    private JTextField vec2x;
    private JTextField vec2y;
    private JTextField vec2z;
    private JTextField vec3x;
    private JTextField vec3y;
    private JTextField vec3z;

    public AnimDynmPlPanel(String dir, String modeData) {
        super("run animate.pl", dir, new Dimension(300, 200));
        this.modeData = modeData;
        this.init();
    }

    public AnimDynmPlPanel(String dir, String modeData, String scriptName, String[] comp) {
        super("run " + scriptName, dir, new Dimension(300, 200));
        this.modeData = modeData;
        this.scriptName = scriptName;
        this.comp = comp;
        this.init();
    }

    private void init() {
        String ctrinp = String.valueOf(this.baseDir) + this.FS + "control.inp";
        if (new File(ctrinp).exists()) {
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(ctrinp));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        String[] vec3;
                        String[] vec2;
                        String[] vec1;
                        String[] origs;
                        this.logger.debug((Object)("line: " + line));
                        if (line.trim().startsWith("origin") && (origs = line.split("\\s+")).length >= 4) {
                            this.origx.setText(origs[1]);
                            this.origy.setText(origs[2]);
                            this.origz.setText(origs[3]);
                        }
                        if (line.trim().startsWith("vector1") && (vec1 = line.split("\\s+")).length >= 4) {
                            this.vec1x.setText(vec1[1]);
                            this.vec1y.setText(vec1[2]);
                            this.vec1z.setText(vec1[3]);
                        }
                        if (line.trim().startsWith("vector2") && (vec2 = line.split("\\s+")).length >= 4) {
                            this.vec2x.setText(vec2[1]);
                            this.vec2y.setText(vec2[2]);
                            this.vec2z.setText(vec2[3]);
                        }
                        if (!line.trim().startsWith("vector3") || (vec3 = line.split("\\s+")).length < 4) continue;
                        this.vec3x.setText(vec3[1]);
                        this.vec3y.setText(vec3[2]);
                        this.vec3z.setText(vec3[3]);
                    }
                }
                catch (Exception exception) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public JPanel createMainPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        ret.setBorder(new TitledBorder("control.inp"));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 4));
        p1.add(new JLabel("origin"));
        this.origx = new JTextField(5);
        this.origy = new JTextField(5);
        this.origz = new JTextField(5);
        p1.add(this.origx);
        p1.add(this.origy);
        p1.add(this.origz);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 4));
        p2.add(new JLabel("vector1"));
        this.vec1x = new JTextField(5);
        this.vec1y = new JTextField(5);
        this.vec1z = new JTextField(5);
        p2.add(this.vec1x);
        p2.add(this.vec1y);
        p2.add(this.vec1z);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(1, 4));
        p3.add(new JLabel("vector2"));
        this.vec2x = new JTextField(5);
        this.vec2y = new JTextField(5);
        this.vec2z = new JTextField(5);
        p3.add(this.vec2x);
        p3.add(this.vec2y);
        p3.add(this.vec2z);
        JPanel p4 = new JPanel();
        p4.setLayout(new GridLayout(1, 4));
        p4.add(new JLabel("vector3"));
        this.vec3x = new JTextField(5);
        this.vec3y = new JTextField(5);
        this.vec3z = new JTextField(5);
        p4.add(this.vec3x);
        p4.add(this.vec3y);
        p4.add(this.vec3z);
        ret.add(p1);
        ret.add(p2);
        ret.add(p3);
        ret.add(p4);
        return ret;
    }

    @Override
    public boolean createExeString() {
        String controlinp;
        String anim;
        block20: {
            anim = this.getPerlScript(this.scriptName);
            controlinp = "";
            String origin = null;
            String vector1 = null;
            String vector2 = null;
            String vector3 = null;
            try {
                String ox = this.origx.getText();
                String oy = this.origy.getText();
                String oz = this.origz.getText();
                if (ox.length() != 0 && oy.length() != 0 && oz.length() != 0) {
                    origin = "origin " + ox + " " + oy + " " + oz;
                }
                String ve1x = this.vec1x.getText();
                String ve1y = this.vec1y.getText();
                String ve1z = this.vec1z.getText();
                if (ve1x.length() != 0 && ve1y.length() != 0 && ve1z.length() != 0) {
                    vector1 = "vector1 " + ve1x + " " + ve1y + " " + ve1z;
                }
                String ve2x = this.vec2x.getText();
                String ve2y = this.vec2y.getText();
                String ve2z = this.vec2z.getText();
                if (ve2x.length() != 0 && ve2y.length() != 0 && ve2z.length() != 0) {
                    vector2 = "vector2 " + ve2x + " " + ve2y + " " + ve2z;
                }
                String ve3x = this.vec3x.getText();
                String ve3y = this.vec3y.getText();
                String ve3z = this.vec3z.getText();
                if (ve3x.length() != 0 && ve3y.length() != 0 && ve3z.length() != 0) {
                    vector3 = "vector3 " + ve3x + " " + ve3y + " " + ve3z;
                }
            }
            catch (Exception ox) {
                // empty catch block
            }
            String str = "";
            String LS = System.getProperty("line.separator");
            if (origin != null) {
                str = String.valueOf(str) + origin + LS;
            }
            if (vector1 != null && vector2 != null && vector3 != null) {
                str = String.valueOf(str) + vector1 + LS;
                str = String.valueOf(str) + vector2 + LS;
                str = String.valueOf(str) + vector3;
            }
            if (str.trim().length() != 0) {
                controlinp = String.valueOf(this.baseDir) + System.getProperty("file.separator") + "control.inp";
                BufferedWriter writer = null;
                try {
                    try {
                        writer = new BufferedWriter(new FileWriter(controlinp));
                        writer.write(str, 0, str.length());
                    }
                    catch (Exception exc) {
                        this.logger.error((Object)"failed creation of control.inp");
                        controlinp = "";
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {}
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.exeString = controlinp.length() != 0 ? String.valueOf(anim) + " " + Utils.getPathDQ(String.valueOf(this.baseDir) + this.FS + this.modeData) + " " + Utils.getPathDQ(controlinp) : String.valueOf(anim) + " " + Utils.getPathDQ(String.valueOf(this.baseDir) + this.FS + this.modeData);
        return true;
    }

    @Override
    public void bootPostProcess() {
        String moveToDir = this.baseDir;
        String moveFromDir = System.getProperty("user.dir");
        String[] files = new File(moveFromDir).list();
        if (files == null || files.length == 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            int j = 0;
            while (j < this.comp.length) {
                if (files[i].matches(this.comp[j])) {
                    String moveFromFile = String.valueOf(moveFromDir) + this.FS + files[i];
                    String moveToFile = String.valueOf(moveToDir) + this.FS + files[i];
                    if (moveToFile.trim().equalsIgnoreCase(moveToFile.trim())) {
                        ExternalProgramExecuter.remove(moveToFile);
                    }
                    ExternalProgramExecuter.move(moveFromFile, moveToFile);
                }
                ++j;
            }
            ++i;
        }
    }
}

