/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VLCAVParser
extends OutputParser
implements ProgressInfo {
    private Logger logger = Logger.getLogger((String)VLCAVParser.class.getName());
    private OutputData outputData;
    private Vector dataVector = new Vector();
    private String[] idents = new String[]{"distance along z-axis(A)", "Vloc(eV)", "Vfluc", "Efermi(eV)"};

    public VLCAVParser(String fileName) {
        super(fileName);
        this.outputData = new OutputData();
        this.outputData.setFileName(fileName);
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }

    @Override
    protected boolean parse() {
        if (this.reader == null) {
            return false;
        }
        String line = "";
        this.dataVector = new Vector();
        try {
            try {
                while ((line = this.reader.readLine()) != null) {
                    this.parseLine(line.trim());
                }
                String[][] data = new String[this.dataVector.size()][];
                this.dataVector.copyInto((Object[])data);
                this.outputData.setName("vlocav");
                this.outputData.setDescription("average of the local potential");
                this.outputData.setData2D(data);
                this.addOutputData(this.outputData);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.isDone = true;
                try {
                    this.reader.close();
                }
                catch (IOException ioe2) {
                    this.logger.error((Object)("failed to finalize read of file: " + this.fileName));
                }
                return false;
            }
        }
        finally {
            this.isDone = true;
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                this.logger.error((Object)("failed to finalize read of file: " + this.fileName));
            }
        }
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith("#")) {
            this.outputData.setIdentifier(this.idents);
            return;
        }
        String[] array = line.split("\\s+");
        this.dataVector.addElement(array);
    }
}

