/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DosParser
extends OutputParser
implements ProgressInfo {
    private Logger logger = Logger.getLogger((String)DosParser.class.getName());
    private final String START = "No.";
    private final String START_ALDOS = "ALDOS";
    private final String START_LAYER = "LAYERDOS";
    private final String START_PDOS = "PDOS";
    private final String END = "END";
    private final int DOS = 0;
    private final int ALDOS = 1;
    private final int LAYERDOS = 2;
    private final int PDOS = 3;
    private boolean in_total = true;
    private int dosmode = 0;
    private OutputData outData;
    private Vector dosVector = new Vector();
    private String dosname = "DOS";
    private String dosdescription = "density of states";

    public DosParser(String fileName) {
        super(fileName);
        this.outData = new OutputData();
        this.outData.setFileName(fileName);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean parse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseLine(String line) {
        if (line.startsWith("No.") || line.startsWith("ALDOS") || line.startsWith("LAYERDOS") || line.startsWith("PDOS")) {
            this.parseHeader(line);
        } else if (line.startsWith("END")) {
            this.parseEnd(line);
        } else {
            this.parseData(line);
        }
    }

    private void parseHeader(String line) {
        String[] aline;
        if (line.startsWith("ALDOS")) {
            this.dosmode = 1;
            this.dosname = "ALDOS";
            aline = line.split("\\s+");
            String numat = "???";
            if (aline != null && aline.length >= 4) {
                numat = aline[3];
            }
            this.dosdescription = "atomic local dos for atom no. " + numat;
            if (numat.length() != 0) {
                this.dosname = String.valueOf(this.dosname) + " " + numat;
            }
        } else if (line.startsWith("LAYERDOS")) {
            this.dosmode = 2;
            this.dosname = "LAYERDOS";
            aline = line.split("\\s+");
            String numlayer = "???";
            if (aline != null && aline.length >= 4) {
                numlayer = aline[3];
            }
            this.dosdescription = "layer dos for layer no. " + numlayer;
            if (numlayer.length() != 0) {
                this.dosname = String.valueOf(this.dosname) + " " + numlayer;
            }
        } else if (line.startsWith("PDOS")) {
            this.dosmode = 3;
            this.dosname = "PDOS ";
            aline = line.split(":");
            String foo = "";
            if (aline != null && aline.length >= 2) {
                String pdosd = aline[1].trim();
                String[] tmp = pdosd.split("\\s+");
                if (tmp != null && tmp.length >= 8) {
                    this.dosname = String.valueOf(this.dosname) + "ia:" + tmp[1] + " l:" + tmp[3] + " m:" + tmp[5] + " t:" + tmp[7];
                }
                this.dosdescription = "pdos : " + aline[1].trim();
            }
        } else if (this.in_total) {
            this.dosname = "DOS";
            this.dosdescription = "density of states";
        }
        if (line.startsWith("No.")) {
            this.in_total = false;
            String[] idents = line.split("\\s+");
            this.outData.setName(this.dosname);
            this.outData.setDescription(this.dosdescription);
            this.outData.setIdentifier(idents);
        }
    }

    private void parseEnd(String line) {
        String[][] data2d = null;
        if (this.dosVector != null && this.dosVector.size() != 0) {
            data2d = new String[this.dosVector.size()][this.outData.getNumCols()];
            int i = 0;
            while (i < this.dosVector.size()) {
                data2d[i] = (String[])this.dosVector.elementAt(i);
                ++i;
            }
        }
        this.outData.setData2D(data2d);
        this.addOutputData(this.outData);
        this.outData = new OutputData();
        this.outData.setFileName(this.fileName);
        this.dosVector = new Vector();
    }

    private void parseData(String line) {
        String[] data = line.split("\\s+");
        this.dosVector.addElement(data);
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }
}

