/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.mainpanel.DefaultInternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.TSpaceRotComboListener;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class SymmetryPanel
extends ProjectManipulator {
    private Logger logger = Logger.getLogger((String)SymmetryPanel.class.getName());
    private File projDir;
    private InputInterface inputInterface;
    private JPanel pchecksym;
    private JPanel pshow;

    public SymmetryPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.projDir = new File(projectInfo.getProjectDirectory());
        this.inputInterface = projectInfo.getInputInterface();
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(new SymmetryPanelPanel(projectInfo.getInputInterface()));
        this.add(scr);
    }

    @Override
    public void init() {
    }

    @Override
    public void initializeProject() {
    }

    class SymmetryPanelPanel
    extends PhaseInputItems
    implements InputInterfaceEntryChangeListener {
        private TableForInputInterface tbl_tspace;
        private boolean checkingSymmetry;
        private JButton checksym;

        SymmetryPanelPanel(InputInterface inputInterface) {
            super(inputInterface);
            this.checkingSymmetry = false;
        }

        @Override
        public void createGUI() {
            this.inputInterface.addInputInterfaceEntryChangeListener(this);
            JPanel pall = new JPanel();
            pall.setLayout(new BoxLayout(pall, 1));
            JPanel pone = new JPanel();
            pone.setLayout(new GridLayout(1, 4));
            String struc = "structure.";
            String[] ctspecs = new String[]{String.valueOf(struc) + "unit_cell_type"};
            String[] ctchoice = new String[]{this.NO_SELECTION, "Primitive", "Bravais"};
            ChoicePanelPhase cppcelltype = new ChoicePanelPhase(ctspecs, this.inputInterface, "unit cell type", ctchoice, this);
            String symmtag = "structure.symmetry.";
            String[] methodspec = new String[]{String.valueOf(symmtag) + "method"};
            String[] methodchoice = new String[]{this.NO_SELECTION, "automatic"};
            ChoicePanelPhase cppmethod = new ChoicePanelPhase(methodspec, this.inputInterface, "method", methodchoice, this);
            pone.add(cppcelltype);
            pone.add(cppmethod);
            JPanel p_cryst = new JPanel();
            p_cryst.setLayout(new BoxLayout(p_cryst, 0));
            String[] crystalspec = new String[]{"structure.symmetry.crystal_structure"};
            String[] crystals = new String[]{this.NO_SELECTION, "diamond", "hexagonal", "fcc", "bcc", "hcp", "simple_cubic"};
            ChoicePanelPhase crystal = new ChoicePanelPhase(crystalspec, this.inputInterface, "crystal structure", crystals, this);
            String[] invsymspec = new String[]{"structure.symmetry.sw_inversion"};
            String[] on_off_forc = new String[]{"off", "on"};
            ChoicePanelPhase invsym = new ChoicePanelPhase(invsymspec, this.inputInterface, "inversion", on_off_forc, this);
            pone.add(invsym);
            JPanel p_tspace = new JPanel();
            p_tspace.setLayout(new BoxLayout(p_tspace, 1));
            p_tspace.setBorder(new TitledBorder("tspace"));
            JPanel p_tspace_misc = new JPanel();
            p_tspace_misc.setLayout(new BoxLayout(p_tspace_misc, 0));
            String[] latticesymmspec = new String[]{"structure.symmetry.tspace.lattice_system", "structure.symmetry.tspace.system"};
            String[] latticesymmchoi = new String[]{this.NO_SELECTION, "primitive", "facecentered", "bodycentered", "basecentered", "rhombohedral", "hexagonal"};
            ChoicePanelPhase latticesymm = new ChoicePanelPhase(latticesymmspec, this.inputInterface, "lattice system", latticesymmchoi, this);
            String[] genspec = new String[]{"structure.symmetry.tspace.num_generators"};
            String[] NUM_GEN = new String[]{this.NO_SELECTION, "1", "2", "3"};
            ChoicePanelPhase gen = new ChoicePanelPhase(genspec, this.inputInterface, "number of generators", NUM_GEN, this);
            pone.add(latticesymm);
            p_tspace.add(p_tspace_misc);
            p_tspace.add(Box.createVerticalGlue());
            String[] gentablespec = new String[]{"structure.symmetry.tspace.generators"};
            JPanel p_tspace_table = new JPanel();
            p_tspace_table.setBorder(new TitledBorder("generators"));
            this.tbl_tspace = new TableForInputInterface(gentablespec, this.inputInterface, this);
            this.tbl_tspace.setColumnSelectionAllowed(true);
            this.tbl_tspace.setRowSelectionAllowed(true);
            JScrollPane scrPane = new JScrollPane();
            scrPane.getViewport().setView(this.tbl_tspace.getPanel());
            scrPane.setPreferredSize(new Dimension(500, 70));
            p_tspace_table.add(scrPane);
            p_tspace.add(p_tspace_table);
            int[] intarray = new int[1];
            latticesymm.registerDisabableGUI(intarray, gen);
            latticesymm.registerDisabableGUI(intarray, this.tbl_tspace);
            pall.add(pone);
            this.setLayout(new BorderLayout());
            this.add((Component)pall, "North");
            ((JComboBox)((DefaultCellEditor)this.tbl_tspace.getColumnModel().getColumn(0).getCellEditor()).getComponent()).addActionListener(new TSpaceRotComboListener(this.tbl_tspace));
            this.checksym = new JButton("check symmetry");
            JPanel ppchecksym = new JPanel();
            ppchecksym.add(this.checksym);
            SymmetryPanel.this.pchecksym = new JPanel();
            SymmetryPanel.this.pchecksym.add((Component)ppchecksym, "West");
            SymmetryPanel.this.pshow = new JPanel();
            SymmetryPanel.this.pshow.setLayout(new BoxLayout(SymmetryPanel.this.pshow, 1));
            this.add((Component)SymmetryPanel.this.pchecksym, "South");
            this.checksym.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(new SymmetryChecker()).start();
                }
            });
        }

        @Override
        public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
            String tag = e.getTag();
            if (tag == null || !tag.equalsIgnoreCase("structure.symmetry.tspace")) {
                return;
            }
            InputInterfaceEntry ent = e.getEntry();
            if (ent == null || !(ent instanceof InputInterfacePrimitiveEntry)) {
                return;
            }
            if (!((InputInterfacePrimitiveEntry)ent).getName().equalsIgnoreCase("lattice_system")) {
                return;
            }
            Utils.stop(this.tbl_tspace);
            this.tbl_tspace.updateCellEditor(0);
            ((JComboBox)((DefaultCellEditor)this.tbl_tspace.getColumnModel().getColumn(0).getCellEditor()).getComponent()).addActionListener(new TSpaceRotComboListener(this.tbl_tspace));
        }

        @Override
        public void inputInterfaceInitializing() {
        }

        @Override
        public void inputInterfaceInitialized() {
        }

        class SymmetryChecker
        implements Runnable {
            private String phase_prep = String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "phase_prep";
            private DefaultInternalFrameChase panel;

            SymmetryChecker() {
            }

            @Override
            public void run() {
                Vector<String> show;
                Object foo;
                block62: {
                    File tmpfname;
                    File tmpinput;
                    block60: {
                        if (SymmetryPanelPanel.this.checkingSymmetry) {
                            return;
                        }
                        SymmetryPanelPanel.this.checkingSymmetry = true;
                        tmpinput = null;
                        try {
                            tmpinput = File.createTempFile("input", null, SymmetryPanel.this.projDir);
                        }
                        catch (IOException ioe) {
                            SymmetryPanel.this.logger.error((Object)"failed to create tmp input file!");
                            SymmetryPanelPanel.this.checkingSymmetry = false;
                            return;
                        }
                        if (tmpinput == null) {
                            SymmetryPanel.this.logger.error((Object)"failed to create tmp input file!");
                            SymmetryPanelPanel.this.checkingSymmetry = false;
                            return;
                        }
                        SymmetryPanelPanel.this.inputInterface.saveTo(tmpinput);
                        boolean isMesh = SymmetryPanelPanel.this.inputInterface.getInputInterfacePrimitiveEntry("accuracy.ksampling.method").getValue().trim().equalsIgnoreCase("mesh");
                        File fname = new File(String.valueOf(SymmetryPanel.this.projDir.getAbsolutePath()) + System.getProperty("file.separator") + "file_names.data");
                        tmpfname = new File(String.valueOf(fname.getAbsolutePath()) + "__");
                        if (!fname.exists()) {
                            SymmetryPanelPanel.this.checkingSymmetry = false;
                            return;
                        }
                        try {
                            ExternalProgramExecuter.copyBinary(fname.getAbsolutePath(), tmpfname.getAbsolutePath());
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            SymmetryPanelPanel.this.checkingSymmetry = false;
                            return;
                        }
                        BufferedReader reader = null;
                        OutputStreamWriter writer = null;
                        try {
                            try {
                                reader = Utils.getReader(fname.getAbsolutePath());
                                String li = "";
                                String ac = "";
                                boolean swapinp = false;
                                while ((li = reader.readLine()) != null) {
                                    if (!li.trim().startsWith("F_INP")) {
                                        ac = String.valueOf(ac) + li + System.getProperty("line.separator");
                                        continue;
                                    }
                                    ac = String.valueOf(ac) + "F_INP='./" + tmpinput.getName() + "'" + System.getProperty("line.separator");
                                    swapinp = true;
                                }
                                if (!swapinp) {
                                    ac = String.valueOf(ac) + "F_INP='./" + tmpinput.getName() + "'";
                                }
                                writer = new FileWriter(fname);
                                writer.write(ac, 0, ac.length());
                            }
                            catch (IOException ioe) {
                                try {
                                    ExternalProgramExecuter.copyBinary(tmpfname.getAbsolutePath(), fname.getAbsolutePath());
                                }
                                catch (IOException ioerr) {
                                    ioerr.printStackTrace();
                                }
                                ioe.printStackTrace();
                                SymmetryPanelPanel.this.checkingSymmetry = false;
                                try {
                                    writer.flush();
                                    writer.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                return;
                            }
                        }
                        finally {
                            try {
                                writer.flush();
                                writer.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            try {
                                String exe = this.phase_prep;
                                if (Utils.isWindows()) {
                                    exe = String.valueOf(exe) + ".exe";
                                }
                                BufferedReader[] rd = ExternalProgramExecuter.executeGetBR(exe, SymmetryPanel.this.projDir);
                                while (rd[0].readLine() != null) {
                                }
                                while (rd[1].readLine() != null) {
                                }
                                rd[0].close();
                                rd[1].close();
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                try {
                                    ExternalProgramExecuter.copyBinary(tmpfname.getAbsolutePath(), fname.getAbsolutePath());
                                }
                                catch (IOException ioe2) {
                                    ioe2.printStackTrace();
                                }
                                break block60;
                            }
                        }
                        catch (Throwable swapinp) {
                            try {
                                ExternalProgramExecuter.copyBinary(tmpfname.getAbsolutePath(), fname.getAbsolutePath());
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                            throw swapinp;
                        }
                        try {
                            ExternalProgramExecuter.copyBinary(tmpfname.getAbsolutePath(), fname.getAbsolutePath());
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    SymmetryPanel.this.logger.info((Object)"end of symmetry check");
                    Object[] files = SymmetryPanel.this.projDir.listFiles(new FilenameFilter(){
                        private String mat = "output\\d+";

                        @Override
                        public boolean accept(File arg0, String arg1) {
                            return arg1.matches(this.mat);
                        }
                    });
                    tmpinput.delete();
                    tmpfname.delete();
                    if (files == null || files.length == 0) {
                        SymmetryPanelPanel.this.checkingSymmetry = false;
                        return;
                    }
                    Arrays.sort(files);
                    foo = files[files.length - 1];
                    BufferedReader rd = null;
                    rd = Utils.getReader(((File)foo).getAbsolutePath());
                    show = new Vector<String>();
                    if (rd != null) {
                        String line = "";
                        try {
                            try {
                                while ((line = rd.readLine()) != null) {
                                    if ((line = line.trim()).startsWith("Bravais lattice:")) {
                                        show.add(line);
                                    }
                                    if (line.startsWith("Crystallographic")) {
                                        show.add(line);
                                    }
                                    if (line.startsWith("Space group")) {
                                        show.add(line);
                                    }
                                    if (line.startsWith("number of k-points in full BZ")) {
                                        show.add(line);
                                    }
                                    if (!line.startsWith("=== k-points generated ===")) continue;
                                    rd.readLine();
                                    int numK = 0;
                                    try {
                                        while (true) {
                                            Double.parseDouble(rd.readLine().trim().split("\\s+")[0]);
                                            ++numK;
                                        }
                                    }
                                    catch (Exception exception) {
                                        show.add("number of generated k-points = " + String.valueOf(numK));
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                try {
                                    rd.close();
                                }
                                catch (IOException ioe3) {
                                    ioe3.printStackTrace();
                                }
                                break block62;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                rd.close();
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            rd.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
                Object[] res = new String[show.size()];
                JPanel pan = new JPanel();
                pan.setLayout(new BoxLayout(pan, 1));
                show.copyInto(res);
                SymmetryPanel.this.pshow.removeAll();
                SymmetryPanel.this.pshow.setLayout(new BoxLayout(SymmetryPanel.this.pshow, 1));
                if (res != null) {
                    int i = 0;
                    while (i < res.length) {
                        JPanel ptmp = new JPanel();
                        ptmp.add(new JLabel((String)res[i]));
                        SymmetryPanel.this.pshow.add(ptmp);
                        ++i;
                    }
                }
                this.panel = new DefaultInternalFrameChase("symmetry", new Dimension(250, 200));
                this.panel.getContentPane().setLayout(new BoxLayout(this.panel.getContentPane(), 1));
                this.panel.getContentPane().add(SymmetryPanel.this.pshow);
                JButton btn = new JButton("dismiss");
                JPanel pbtn = new JPanel();
                pbtn.add(btn);
                this.panel.getContentPane().add(pbtn);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        SymmetryChecker.this.panel.dispose();
                    }
                });
                SymmetryPanelPanel.this.revalidate();
                ((File)foo).delete();
                SymmetryPanelPanel.this.checkingSymmetry = false;
            }
        }
    }
}

