/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputChildrenPanel;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class ElementList
extends PhaseInputChildrenPanel {
    private static Logger logger = Logger.getLogger((String)ElementList.class.getName());
    private ElementInfo eI;
    private String[] elements_list;
    private String[] atomic_num_list;
    private JComboBox combo_elm;
    private JComboBox combo_num;
    private TableForInputInterface tbl_elm;
    private ChoicePanelPhase cppelm;
    private ChoicePanelPhase cppatnum;
    private InputPanelPhase ippmass;

    public ElementList(InputInterface inputInterface) {
        super("Element List", true, true, true, true, inputInterface, new Dimension(500, 450));
    }

    @Override
    public void createGUI() {
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        cont.add(this.createElementListPanel());
        this.setResizable(true);
    }

    public void delete() {
    }

    public void add() {
    }

    @Override
    public void save() {
    }

    private JPanel createElementListPanel() {
        this.eI = ElementInfo.getElementInfo();
        int num_elements = this.eI.num_elements;
        this.elements_list = new String[num_elements - 1];
        this.atomic_num_list = new String[num_elements - 1];
        int i = 1;
        while (i < num_elements) {
            this.elements_list[i - 1] = this.eI.getSymbolFromNumber(i);
            this.atomic_num_list[i - 1] = Integer.toString(i);
            logger.debug((Object)("got symbol: " + this.eI.getSymbolFromNumber(i) + " whose atomic number is: " + i));
            ++i;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        String[] elmSpec = new String[]{"structure.element_list"};
        String[] colname_elm = new String[]{"element", "atomicnumber", "mass", "zeta", "deviation"};
        this.tbl_elm = new TableForInputInterface(elmSpec, this.inputInterface, this);
        this.tbl_elm.setColumnSelectionAllowed(true);
        this.tbl_elm.setRowSelectionAllowed(true);
        this.setEditorForElementTable();
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(this.tbl_elm.getPanel());
        scrPane.setPreferredSize(new Dimension(450, 200));
        p.add(scrPane);
        return p;
    }

    private void setEditorForElementTable() {
        TableColumn column_elm = this.tbl_elm.getColumnModel().getColumn(0);
        this.combo_elm = new JComboBox<String>(this.elements_list);
        column_elm.setCellEditor(new DefaultCellEditor(this.combo_elm));
        TableColumn column_num = this.tbl_elm.getColumnModel().getColumn(1);
        this.combo_num = new JComboBox<String>(this.atomic_num_list);
        column_num.setCellEditor(new DefaultCellEditor(this.combo_num));
        this.combo_elm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String symbolSelected = (String)ElementList.this.combo_elm.getSelectedItem();
                int row = ElementList.this.tbl_elm.getSelectedRow();
                if (row >= 0 && ElementList.this.combo_elm.isPopupVisible()) {
                    try {
                        ElementList.this.tbl_elm.setValueAt(String.valueOf(ElementList.this.eI.getNumberFromSymbol(symbolSelected)), row, 1);
                        ElementList.this.tbl_elm.setValueAt(ElementList.this.eI.getMassFromSymbol(symbolSelected), row, 2);
                    }
                    catch (Exception ee) {
                        System.out.println("failed to obtain number and mass from symbol");
                        ee.printStackTrace();
                    }
                }
                ElementList.this.updateTable();
            }
        });
        this.combo_num.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String numberSelected = (String)ElementList.this.combo_num.getSelectedItem();
                int row = ElementList.this.tbl_elm.getSelectedRow();
                if (row >= 0 && ElementList.this.combo_num.isPopupVisible()) {
                    try {
                        ElementList.this.tbl_elm.setValueAt(ElementList.this.eI.getSymbolFromNumber(Integer.parseInt(numberSelected)), row, 0);
                        ElementList.this.tbl_elm.setValueAt(ElementList.this.eI.getMassFromNumber(Integer.parseInt(numberSelected)), row, 2);
                    }
                    catch (Exception ee) {
                        System.out.println("failed to obtain symbol and mass from atomic number");
                    }
                }
                ElementList.this.updateTable();
            }
        });
    }

    private void updateTable() {
        this.tbl_elm.update(this.tbl_elm.getGraphics());
    }
}

