/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.BondAngleDiffEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.BondAngleEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.BondLengthDiffEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.BondLengthEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.BondLengthSumEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.CenterOfMassEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.CoordinationNumberEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.DihedralAngleEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.DistanceFromPosEditor;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.PlaneEditor;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

abstract class ConstraintsEditor
extends PhaseInputItems {
    public static String BOND_LENGTH = "bond_length";
    public static String BOND_ANGLE = "bond_angle";
    public static String DIHEDRAL_ANGLE = "dihedral_angle";
    public static String BOND_LENGTH_DIFF = "bond_length_diff";
    public static String BOND_LENGTH_SUM = "bond_length_sum";
    public static String BOND_ANGLE_DIFF = "bond_angle_diff";
    public static String DISTANCE_FROM_POS = "distance_from_pos";
    public static String PLANE = "plane";
    public static String CENTER_OF_MASS = "center_of_mass";
    public static String COORDINATION_NUMBER = "coordination_number";
    public static String[] CONSTRAINTS = new String[]{BOND_LENGTH, BOND_ANGLE, DIHEDRAL_ANGLE, BOND_LENGTH_DIFF, BOND_LENGTH_SUM, BOND_ANGLE_DIFF, DISTANCE_FROM_POS, PLANE, CENTER_OF_MASS, COORDINATION_NUMBER};
    protected String constrainable = "structure.constrainable";
    protected int ID;
    protected static Logger logger = Logger.getLogger((String)ConstraintsEditor.class.getName());
    protected String constraintType;

    protected String getConstrainableTag() {
        return String.valueOf(this.constrainable) + String.valueOf(this.ID) + ".";
    }

    public ConstraintsEditor(ProjectInfo projectInfo, int ID, String typ) {
        this.projectInfo = projectInfo;
        this.inputInterface = projectInfo.getInputInterface();
        this.ID = ID;
        this.constraintType = typ;
        this.createGUI();
    }

    public void setID(int newID) {
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock("structure");
        this.inputInterface.getBlock("constrainable" + String.valueOf(this.ID)).setName("constrainable" + String.valueOf(newID));
        this.inputInterface.selectRoot();
        this.ID = newID;
        this.removeAll();
        this.genGUI();
    }

    private void genGUI() {
        JPanel pall = new JPanel();
        pall.setLayout(new BoxLayout(pall, 0));
        InputPanelPhase ippsilent = new InputPanelPhase(new String[]{String.valueOf(this.getConstrainableTag()) + "type"}, this.inputInterface, "", 0, 1, this);
        if (!this.inputInterface.getInputInterfacePrimitiveEntry(String.valueOf(this.getConstrainableTag()) + "type").getValue().equals(this.constraintType)) {
            ippsilent.getTextField().setText(this.constraintType);
        }
        JPanel passc = new JPanel();
        passc.setLayout(new BoxLayout(passc, 1));
        String associatedTag = String.valueOf(this.getConstrainableTag()) + "atom";
        int i = 0;
        while (i < this.getNumAssociatedAtoms()) {
            String[] atomxx = new String[]{String.valueOf(associatedTag) + String.valueOf(i + 1)};
            InputPanelPhase ipp = new InputPanelPhase(atomxx, this.inputInterface, "atom" + String.valueOf(i + 1), 0, 5, this);
            JPanel pp = new JPanel();
            pp.add(ipp);
            passc.add(pp);
            ++i;
        }
        JPanel ptmp = new JPanel();
        ptmp.add(passc);
        JScrollPane scrpane = new JScrollPane(ptmp);
        scrpane.setPreferredSize(new Dimension(150, 150));
        pall.add(scrpane);
        ChoicePanelPhase cppmob = new ChoicePanelPhase(new String[]{String.valueOf(this.getConstrainableTag()) + "mobile"}, this.inputInterface, "mobile", this.ON_OFF, this.ON_OFF_DUPLI, this);
        ChoicePanelPhase cppmon = new ChoicePanelPhase(new String[]{String.valueOf(this.getConstrainableTag()) + "monitor"}, this.inputInterface, "monitor", this.ON_OFF, this.ON_OFF_DUPLI, this);
        JPanel psw = new JPanel();
        psw.setLayout(new BoxLayout(psw, 1));
        JPanel ptmp0 = new JPanel();
        ptmp0.add(cppmob);
        JPanel ptmp1 = new JPanel();
        ptmp1.add(cppmon);
        psw.add(ptmp0);
        psw.add(ptmp1);
        JPanel pp = new JPanel();
        pp.add(psw);
        pall.add(pp);
        JButton pmisc = new JButton("other settings");
        pmisc.setEnabled(false);
        psw.add(pmisc);
        if (this.requiresSubGUI()) {
            pmisc.setEnabled(true);
            pmisc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ConstraintsEditor.this.generateSubGUI();
                }
            });
        }
        JPanel preac = new JPanel();
        preac.setLayout(new BoxLayout(preac, 1));
        ChoicePanelPhase ippreac = new ChoicePanelPhase(new String[]{String.valueOf(this.getConstrainableTag()) + "reaction_coordinate.sw_reaction_coordinate"}, this.inputInterface, "reaction coordinate", this.ON_OFF, this.ON_OFF_DUPLI, this);
        ippreac.setPreferredSize(new Dimension(ippreac.getPreferredSize().width + 60, ippreac.getPreferredSize().height));
        JPanel prea = new JPanel();
        prea.add(ippreac);
        preac.add(prea);
        JPanel pval = new JPanel();
        pval.setLayout(new BoxLayout(pval, 1));
        JPanel pinit = new JPanel();
        pinit.setLayout(new BoxLayout(pinit, 0));
        JPanel pfinal = new JPanel();
        pfinal.setLayout(new BoxLayout(pfinal, 0));
        JPanel pincre = new JPanel();
        pincre.setLayout(new BoxLayout(pincre, 0));
        InputPanelPhase ippini = new InputPanelPhase(new String[]{String.valueOf(this.getConstrainableTag()) + "reaction_coordinate.init_value"}, this.inputInterface, "initial value", this.getUnit(), 7, this);
        InputPanelPhase ippfinal = new InputPanelPhase(new String[]{String.valueOf(this.getConstrainableTag()) + "reaction_coordinate.final_value"}, this.inputInterface, "final value", this.getUnit(), 7, this);
        InputPanelPhase ippincre = new InputPanelPhase(new String[]{String.valueOf(this.getConstrainableTag()) + "reaction_coordinate.increment"}, this.inputInterface, "increment", this.getUnit(), 7, this);
        pinit.add(ippini);
        pfinal.add(ippfinal);
        pincre.add(ippincre);
        pval.add(pinit);
        pval.add(pfinal);
        pval.add(pincre);
        preac.add(pval);
        pall.add(preac);
        int[] nArray = new int[2];
        nArray[1] = 2;
        ippreac.registerDisabableGUI(nArray, ippini);
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        ippreac.registerDisabableGUI(nArray2, ippfinal);
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        ippreac.registerDisabableGUI(nArray3, ippincre);
        this.add(pall);
    }

    @Override
    public void createGUI() {
        this.genGUI();
    }

    protected abstract String getNameOfConstraint();

    protected abstract String getDescriptionOfConstraint();

    protected abstract int getNumAssociatedAtoms();

    protected abstract int getNdim();

    protected abstract void generateSubGUI();

    protected abstract boolean requiresSubGUI();

    protected abstract int getUnit();

    public static ConstraintsEditor getEditor(String editor, ProjectInfo pinfo, int ID) {
        ConstraintsEditor edi = null;
        if (editor.equals(BOND_LENGTH)) {
            edi = new BondLengthEditor(pinfo, ID, editor);
        }
        if (editor.equals(BOND_LENGTH_DIFF)) {
            edi = new BondLengthDiffEditor(pinfo, ID, editor);
        }
        if (editor.equals(BOND_LENGTH_SUM)) {
            edi = new BondLengthSumEditor(pinfo, ID, editor);
        }
        if (editor.equals(BOND_ANGLE)) {
            edi = new BondAngleEditor(pinfo, ID, editor);
        }
        if (editor.equals(BOND_ANGLE_DIFF)) {
            edi = new BondAngleDiffEditor(pinfo, ID, editor);
        }
        if (editor.equals(DIHEDRAL_ANGLE)) {
            edi = new DihedralAngleEditor(pinfo, ID, editor);
        }
        if (editor.equals(PLANE)) {
            edi = new PlaneEditor(pinfo, ID, editor);
        }
        if (editor.equals(DISTANCE_FROM_POS)) {
            edi = new DistanceFromPosEditor(pinfo, ID, editor);
        }
        if (editor.equals(COORDINATION_NUMBER)) {
            edi = new CoordinationNumberEditor(pinfo, ID, editor);
        }
        if (editor.equals(CENTER_OF_MASS)) {
            edi = new CenterOfMassEditor(pinfo, ID, editor);
        }
        if (edi == null) {
            logger.error((Object)("undefined constraint : " + editor));
        }
        return edi;
    }

    public void removeTheCurrentConstraint() {
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock("structure");
        this.inputInterface.removeBlock("constrainable" + String.valueOf(this.ID));
        this.inputInterface.selectRoot();
    }
}

