/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.CmixPanelPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.SolverPanelPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class SolverAndCmixWiz
implements InputWizard {
    private Logger logger = Logger.getLogger((String)SolverAndCmixWiz.class.getName());
    private JPanel panel;
    private InputInterface input;
    private JComboBox combo;
    private String[] type = new String[]{"slow", "moderate", "fast"};
    private boolean metallic = false;
    private boolean spin = false;
    int numCand = 3;
    private InputInterface[] inputFrom = new InputInterface[this.numCand];

    @Override
    public String process() {
        this.input.swapBlock(InputInterface.__ROOT__, "wavefunction_solver", this.inputFrom[this.combo.getSelectedIndex()]);
        this.input.swapBlock(InputInterface.__ROOT__, "charge_mixing", this.inputFrom[this.combo.getSelectedIndex()]);
        return "configured solver settings and cmix methods.";
    }

    @Override
    public void setInput(Input input) {
        this.input = (InputInterface)input;
    }

    @Override
    public boolean hasPrevious() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean hasFinished() {
        return true;
    }

    @Override
    public String getName() {
        return "solver and charge mixing";
    }

    @Override
    public JPanel getGUI() {
        if (this.panel == null) {
            this.createGUI();
        }
        return this.panel;
    }

    private void createGUI() {
        this.combo = new JComboBox<String>(this.type);
        this.combo.setSelectedIndex(1);
        JButton btn = new JButton("configure");
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        JPanel p1 = new JPanel();
        p1.add(this.combo);
        JPanel p2 = new JPanel();
        p2.add(btn);
        this.panel.add(p1);
        this.panel.add(p2);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SubPanel subPanel = new SubPanel(SolverAndCmixWiz.this.inputFrom[SolverAndCmixWiz.this.combo.getSelectedIndex()]);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    @Override
    public String getDescription() {
        return "edit configurations for solvers and charge mixing methods.";
    }

    @Override
    public void setProperties(HashMap properties) {
        try {
            this.metallic = new Boolean(properties.get("metallic").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.spin = new Boolean(properties.get("spin").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL definputFile = this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/defaultSolverAndCmix.data");
        String definput = definputFile.getFile();
        this.logger.debug((Object)("definput: " + definput));
        int i = 0;
        while (i < this.numCand) {
            DataManager man = new DataManager(definput, PhaseConstants.TABLESPEC, false);
            man.parse();
            this.inputFrom[i] = man.getInputInterface();
            InputInterfaceTable solver = this.inputFrom[i].getInputInterfaceTable("wavefunction_solver.solvers");
            InputInterfaceTable cmix = this.inputFrom[i].getInputInterfaceTable("charge_mixing.mixing_methods");
            if (this.spin) {
                int rmxsInd = cmix.getIndexFor("rmxs");
                int rmxeInd = cmix.getIndexFor("rmxe");
                Vector vec = cmix.getTableData();
                String[] dat = (String[])vec.get(0);
                dat[rmxsInd] = "0.1";
                dat[rmxeInd] = "0.1";
            }
            this.configInitialSolAndCmix(this.inputFrom[i], i);
            ++i;
        }
    }

    private void configInitialSolAndCmix(InputInterface inp, int i) {
        InputInterfaceTable solver = inp.getInputInterfaceTable("wavefunction_solver.solvers");
        InputInterfaceTable cmix = inp.getInputInterfaceTable("charge_mixing.mixing_methods");
        String[] soldata = (String[])solver.getTableData().get(0);
        String[] cmixdata = (String[])cmix.getTableData().get(0);
        int solmethodind = solver.getIndexFor("sol");
        int till_nind = solver.getIndexFor("till_n");
        int cmixmethodind = cmix.getIndexFor("method");
        if (i == 0) {
            soldata[solmethodind] = "mddavidson";
            soldata[solver.getIndexFor((String)"prec")] = "on";
            soldata[solver.getIndexFor((String)"submat")] = "on";
        } else if (i == 1) {
            String[] rmm3 = new String[]{"rmm3", "-1", "on", "1", "on"};
            soldata[till_nind] = "2";
            solver.replaceTableDataRow(rmm3, 1);
        } else if (i == 2) {
            String[] rmm3 = new String[]{"rmm3", "-1", "on", "1", "on"};
            soldata[till_nind] = "2";
            solver.replaceTableDataRow(rmm3, 1);
            InputInterfacePrimitiveEntry tormm = inp.getInputInterfacePrimitiveEntry("wavefunction_solver.rmm.edelta_change_to_rmm");
            tormm.setValue("0.01");
        }
    }

    @Override
    public void setParent(InputWizardController parent) {
    }

    class SubPanel
    extends InternalFrameChase {
        private InputInterface inp;

        SubPanel(InputInterface inp) {
            super("configure solver and charge-mixing methods", true, true, true, true, new Dimension(530, 530));
            this.inp = inp;
            JPanel foo = new JPanel();
            JTabbedPane pane = new JTabbedPane();
            JPanel psol = new JPanel();
            psol.setLayout(new BorderLayout());
            SolverPanelPanel sol = new SolverPanelPanel(inp);
            psol.add((Component)sol, "North");
            CmixPanelPanel cmix = new CmixPanelPanel(inp);
            JPanel pcmix = new JPanel();
            pcmix.setLayout(new BorderLayout());
            pcmix.add((Component)cmix, "North");
            pane.addTab("solver", psol);
            pane.addTab("charge mixing", pcmix);
            foo.add(pane);
            JButton btn = new JButton("OK");
            JPanel pbtn = new JPanel();
            pbtn.add(btn);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(foo);
            this.getContentPane().add(pbtn);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SubPanel.this.dispose();
                }
            });
        }
    }
}

