/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard.BasicWiz;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BasicWizConvCheck
extends BasicWiz {
    private Logger logger = Logger.getLogger((String)BasicWizConvCheck.class.getName());
    private DecimalFormat format = new DecimalFormat("0.00");

    @Override
    public void createGUI() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.setBorder(new TitledBorder("num. bands and kmesh"));
        String[] specband = new String[]{"accuracy.num_bands"};
        InputPanelPhase numbands = new InputPanelPhase(specband, this.inputInterface, "num. bands", 0, 8, this);
        JPanel pb = new JPanel();
        pb.add(numbands);
        String[] kmeshSpec = new String[]{"accuracy.ksampling.mesh"};
        TableForInputInterface kmeshTable = new TableForInputInterface(kmeshSpec, this.inputInterface, null, this);
        kmeshTable.getModel().addTableModelListener(this);
        numbands.getTextField().setText(String.valueOf(this.defaultNumBands));
        kmeshTable.setValueAt(String.valueOf(this.defaultKmesh[0]), 0, 1);
        kmeshTable.setValueAt(String.valueOf(this.defaultKmesh[1]), 0, 2);
        kmeshTable.setValueAt(String.valueOf(this.defaultKmesh[2]), 0, 3);
        String[] kmethodSpec = new String[]{"accuracy.ksampling.method"};
        String[] kmethodChoice = new String[]{"monk", "mesh", "gamma"};
        ChoicePanelPhase cppkmethod = new ChoicePanelPhase(kmethodSpec, this.inputInterface, "method", kmethodChoice, this);
        cppkmethod.getComboBox().setSelectedIndex(0);
        JPanel ptable = new JPanel();
        ptable.setLayout(new BoxLayout(ptable, 0));
        ptable.setBorder(new TitledBorder("kmesh"));
        ptable.add(cppkmethod);
        ptable.add(kmeshTable.getPanel());
        panel1.add(pb);
        panel1.add(ptable);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new TitledBorder("cutoff and convergence"));
        panel2.setLayout(new BoxLayout(panel2, 0));
        String[] wfspec = new String[]{"accuracy.cutoff_wf"};
        String[] cdspec = new String[]{"accuracy.cutoff_cd"};
        String[] convspec = new String[]{"accuracy.scf_convergence.delta_total_energy"};
        InputPanelPhase ippwf = new InputPanelPhase(wfspec, this.inputInterface, "wave function cutoff", 4, 6, this);
        InputPanelPhase ippcd = new InputPanelPhase(cdspec, this.inputInterface, "charge density cutoff", 4, 6, this);
        InputPanelPhase ippconv = new InputPanelPhase(convspec, this.inputInterface, "SCF convergence", 4, 6, this);
        ippwf.getTextField().setText(this.format.format(this.defaultCutoffWF));
        ippcd.getTextField().setText(this.format.format(this.defaultCutoffCD));
        ippconv.getTextField().setText(String.valueOf(this.defaultDE));
        JPanel pwf = new JPanel();
        JPanel pcd = new JPanel();
        JPanel pconv = new JPanel();
        pwf.add(ippwf);
        pcd.add(ippcd);
        pconv.add(ippconv);
        panel2.add(pwf);
        panel2.add(pcd);
        panel2.add(pconv);
        this.add(panel1);
        this.add(panel2);
        String fs = System.getProperty("file.separator");
        String convcheckscript = String.valueOf(System.getProperty("pviewer.home")) + fs + "scripts" + fs + "jobcontrol" + fs + "phase" + fs + "conv_check.bsh";
        if (!new File(convcheckscript).exists()) {
            this.logger.error((Object)("couldn'find script : " + convcheckscript));
            this.logger.error((Object)"will not configure input for convergence check.");
            return;
        }
    }

    @Override
    public void setProperties(HashMap properties) {
        try {
            this.isMetallic = new Boolean(properties.get("metallic").toString());
            this.spin = new Boolean(properties.get("spin").toString());
            this.coords = (AtomCoords)properties.get("atomcoords");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.debug((Object)("coords: " + this.coords));
        this.defaultNumBands = PhaseUtils.getDefaultNumBands(this.coords, this.isMetallic, this.spin);
        this.logger.debug((Object)("default num. bands: " + this.defaultNumBands));
        Cell cell = this.coords.getCell(0);
        this.defaultKmesh = PhaseUtils.getDefaultKmesh(cell, this.isMetallic);
        int i = 0;
        while (i < this.defaultKmesh.length) {
            if (this.defaultKmesh[i] > 2) {
                int n = i;
                this.defaultKmesh[n] = this.defaultKmesh[n] - 2;
            }
            ++i;
        }
        this.logger.debug((Object)("default kmesh: " + this.defaultKmesh[0] + ", " + this.defaultKmesh[1] + ", " + this.defaultKmesh[2]));
        boolean hasUSPP = PhaseUtils.hasUSPP(this.coords);
        this.defaultCutoffWF *= 0.7;
        this.defaultCutoffCD = hasUSPP ? this.defaultCutoffWF * 9.0 : this.defaultCutoffWF * 4.0;
        this.logger.debug((Object)("default cutoff, wf: " + this.defaultCutoffWF + ", cd: " + this.defaultCutoffCD));
    }
}

