/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputcheck;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.input.PhaseInputChecker;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CmixAndSolver
extends PhaseInputChecker {
    private Logger logger = Logger.getLogger((String)CmixAndSolver.class.getName());
    private final String rmm = "rmm";
    private final String davidson = "davidson";
    private final String simple = "simple";

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public String getName() {
        return "charge mixing scheme and solver settings";
    }

    @Override
    public String getDescription() {
        return "check charge mixing scheme and solver settings";
    }

    @Override
    public String getCandidate() {
        return "";
    }

    @Override
    public boolean fixInput() {
        return true;
    }

    @Override
    public int doCheck() {
        InputInterfaceTable solverTable = this.inputInterface.getInputInterfaceTable("wavefunction_solver.solvers");
        InputInterfaceTable cmixTable = this.inputInterface.getInputInterfaceTable("charge_mixing.mixing_methods");
        int solvercmixInd = solverTable.getIndexFor("cmix");
        int solvermethodInd = solverTable.getIndexFor("sol");
        int cmixMethodInd = cmixTable.getIndexFor("method");
        Vector solvers = solverTable.getTableData();
        Vector cmixs = cmixTable.getTableData();
        int i = 0;
        while (i < solvers.size()) {
            String prec;
            String[] cmdata;
            String cmmethod;
            String[] dat = (String[])solvers.get(i);
            String cmixnum = dat[solvercmixInd];
            if (!Utils.isNumber(cmixnum)) {
                this.message = String.valueOf(this.message) + "invalid cmix specification : " + cmixnum;
                return -2;
            }
            int cmi = Integer.parseInt(cmixnum) - 1;
            if (cmixs.size() < cmi) {
                this.message = String.valueOf(this.message) + "cmix method no. " + cmi + " undefined.";
                return -2;
            }
            String meth = dat[solvermethodInd];
            if (meth.trim().toLowerCase().startsWith("rmm") && !(cmmethod = (cmdata = (String[])cmixs.get(cmi))[cmixMethodInd]).trim().toLowerCase().startsWith("simple")) {
                this.message = String.valueOf(this.message) + "the rmm solver must be used with 'simple' cmix method.";
                return -2;
            }
            if (meth.trim().toLowerCase().startsWith("davidson") && Utils.getBool(prec = dat[solverTable.getIndexFor("prec")])) {
                this.message = String.valueOf(this.message) + "preconditioning must be off for the Davidson solver.";
                return -2;
            }
            ++i;
        }
        return 0;
    }
}

