/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.scripting.scriptreplace.ScriptReplaceRules;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class PhaseScriptReplaceRules
extends ScriptReplaceRules {
    private Logger logger = Logger.getLogger((String)PhaseScriptReplaceRules.class.getName());
    private final String __PHASE__ = "__PHASE__";
    private final String __NE__ = "__NE__";
    private final String __NK__ = "__NK__";
    private final String __NE0__ = "__NE0__";
    private final String __NK0__ = "__NK0__";
    private String[] keys = new String[]{"__NE__", "__NK__", "__PHASE__", "__NE0__", "__NK0__"};

    @Override
    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public String replace(String file, Document document, boolean overwrite2) {
        Element jobcontrol;
        if (document == null || !document.hasRootElement()) {
            this.logger.error((Object)"invalid document");
            return null;
        }
        Element mpiParams = document.getRootElement().getChild("MPI_Params");
        if (mpiParams == null) {
            this.logger.warn((Object)"invalid mpiparams... using defaults");
        }
        if ((jobcontrol = document.getRootElement().getChild(JobController.JOBCONTROL)) == null) {
            this.logger.error((Object)"invalid jobcontrol element");
            return null;
        }
        Element targethost = jobcontrol.getChild("targethost");
        if (targethost == null) {
            this.logger.error((Object)"invalid 'targethost' element");
            return null;
        }
        Element env = targethost.getChild("env");
        if (env == null) {
            this.logger.error((Object)"invalid 'env' element");
            return null;
        }
        String[] keys = this.getKeys();
        int i = 0;
        while (i < keys.length) {
            String nn;
            String key = keys[i];
            if (key.equals("__PHASE__")) {
                String bindir = MyElement.decode(env.getChildTextTrim("bindir"));
                String phase = String.valueOf(bindir) + "/phase";
                if (bindir == null || bindir.trim().length() == 0) {
                    phase = "phase";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    phase = String.valueOf(Utils.escapeBackSlash(bindir)) + "\\\\" + "phase.exe";
                    if (bindir == null || bindir.trim().length() == 0) {
                        phase = "phase.exe";
                    }
                }
                file = file.replaceAll(key, phase);
            } else if (key.equals("__NK__") || key.equals("__NE__")) {
                nn = "1";
                if (mpiParams != null) {
                    String test2 = "";
                    if (key.equals("__NK__")) {
                        test2 = "nk";
                    } else if (key.equals("__NE__")) {
                        test2 = "ne";
                    }
                    nn = MyElement.decode(mpiParams.getChildTextTrim(test2));
                    try {
                        Integer.parseInt(nn);
                    }
                    catch (Exception e) {
                        nn = "1";
                    }
                }
                if (!this.mpiSupport(env, targethost.getTextTrim())) {
                    nn = "";
                }
                file = file.replaceAll(key, nn);
            } else if (key.equals("__NK0__") || key.equals("__NE0__")) {
                nn = "";
                if (this.mpiSupport(env, targethost.getTextTrim())) {
                    if (key.equals("__NK0__")) {
                        nn = "nk=";
                    }
                    if (key.equals("__NE0__")) {
                        nn = "ne=";
                    }
                }
                file = file.replaceAll(key, nn);
            }
            ++i;
        }
        if (!targethost.getTextTrim().equals("localhost") || !System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            file = file.replaceAll("\\r", "");
        }
        return file;
    }

    @Override
    public String replace(String script, Document document) {
        return this.replace(script, document, false);
    }
}

