/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class PhaseInputItems
extends JPanel
implements ActionListener,
CaretListener,
TableModelListener,
ItemListener,
PopupMenuListener {
    protected InputInterface inputInterface;
    protected String NO_SELECTION = ConstParameters.NO_SELECTION;
    protected String[] ON_OFF = new String[]{this.NO_SELECTION, "on", "off"};
    protected Vector ON_OFF_DUPLI = new Vector();
    protected ProjectInfo projectInfo;

    protected PhaseInputItems() {
        this.ON_OFF_DUPLI.addElement(new String[]{"1", "yes"});
        this.ON_OFF_DUPLI.addElement(new String[]{"1", "1"});
        this.ON_OFF_DUPLI.addElement(new String[]{"2", "no"});
        this.ON_OFF_DUPLI.addElement(new String[]{"2", "0"});
    }

    public void setInputInterface(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.inputInterface = projectInfo.getInputInterface();
    }

    protected PhaseInputItems(InputInterface inputInterface) {
        this.ON_OFF_DUPLI.addElement(new String[]{"1", "yes"});
        this.ON_OFF_DUPLI.addElement(new String[]{"1", "1"});
        this.ON_OFF_DUPLI.addElement(new String[]{"2", "no"});
        this.ON_OFF_DUPLI.addElement(new String[]{"2", "0"});
        this.inputInterface = inputInterface;
        this.createGUI();
    }

    protected PhaseInputItems(ProjectInfo projectInfo) {
        this.ON_OFF_DUPLI.addElement(new String[]{"1", "yes"});
        this.ON_OFF_DUPLI.addElement(new String[]{"1", "1"});
        this.ON_OFF_DUPLI.addElement(new String[]{"2", "no"});
        this.ON_OFF_DUPLI.addElement(new String[]{"2", "0"});
        this.inputInterface = projectInfo.getInputInterface();
        this.projectInfo = projectInfo;
        this.createGUI();
    }

    public abstract void createGUI();

    @Override
    public void caretUpdate(CaretEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    protected void fromFile(String parentTag, String tag) {
        ChaseFileChooser chooser = new ChaseFileChooser("input", true);
        chooser.setFileSelectionMode(0);
        if (chooser.showDialog(this, "open") != 0) {
            return;
        }
        String path = chooser.getSelectedFile().getAbsolutePath();
        DataManager manager = new DataManager(path, PhaseConstants.TABLESPEC, false);
        manager.parse();
        InputInterface inputFrom = manager.getInputInterface();
        inputFrom.selectRoot();
        this.inputInterface.swapBlock(parentTag, tag, inputFrom);
        this.recreate();
    }

    protected void recreate() {
        this.removeAll();
        this.createGUI();
        this.revalidate();
    }
}

