/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PhaseFileManager
extends ChaseFileManager {
    private Logger logger = Logger.getLogger((String)PhaseFileManager.class.getName());
    private String programName = "phase";

    public PhaseFileManager(HostInfo hostInfo, URL specFile, File fileSpecFile) {
        super(hostInfo, specFile, fileSpecFile);
    }

    public PhaseFileManager(URL specFile, File fileSpecFile) {
        super(specFile, fileSpecFile);
    }

    private void saveFileNamesData() {
        int potcount = 1;
        PrintWriter fout = null;
        if (this.fileSpecFile.exists() && !this.fileSpecFile.canWrite()) {
            this.logger.debug((Object)(String.valueOf(this.fileSpecFile.getAbsolutePath()) + " exists but cannot be written."));
            return;
        }
        try {
            try {
                String na;
                String relative_path;
                String ident;
                ChaseFile file;
                fout = new PrintWriter(new BufferedWriter(new FileWriter(this.fileSpecFile)));
                fout.println("&fnames");
                ChaseFile[] files = this.getFiles();
                Vector<String> strvec = new Vector<String>();
                int i = 0;
                while (i < files.length) {
                    file = files[i];
                    if (!file.getFileNameEditLevel().equals(ChaseFile.NEVER)) {
                        ident = file.getIdentifier().getValue();
                        relative_path = file.getRelativePath();
                        relative_path = relative_path.replaceAll("\\\\", "/");
                        na = file.getFileName();
                        if (!ident.startsWith("F_POT(")) {
                            strvec.add(String.valueOf(ident) + " = '" + relative_path + "/" + na + "'");
                            this.logger.debug((Object)(String.valueOf(ident) + " = '" + relative_path + "/" + na + "'"));
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < files.length) {
                    file = files[i];
                    if (!file.getFileNameEditLevel().equals(ChaseFile.NEVER)) {
                        ident = file.getIdentifier().getValue();
                        relative_path = file.getRelativePath();
                        relative_path = relative_path.replaceAll("\\\\", "/");
                        na = file.getFileName();
                        if (ident.startsWith("F_POT")) {
                            String filename = String.valueOf(relative_path) + "/" + na;
                            String pot = "F_POT(" + String.valueOf(String.valueOf(potcount)) + ") = '" + filename + "'";
                            if (strvec.size() > potcount) {
                                strvec.add(potcount, pot);
                            } else {
                                strvec.add(pot);
                            }
                            this.logger.debug((Object)pot);
                            ++potcount;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < strvec.size()) {
                    fout.println(strvec.get(i).toString());
                    ++i;
                }
                fout.println("/");
                fout.flush();
            }
            catch (Exception exc) {
                this.logger.warn((Object)"file in use?");
                if (fout != null) {
                    fout.close();
                }
            }
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    @Override
    public void saveSub() {
        this.saveFileNamesData();
    }

    @Override
    public String getName() {
        return "phase";
    }

    @Override
    protected void postInit() {
    }

    @Override
    protected void postRead() {
        this.readFileNamesData();
    }

    private void readFileNamesData() {
        if (!this.fileSpecFile.exists()) {
            this.logger.debug((Object)"no fileSpecFile.");
            return;
        }
        try {
            String entry;
            BufferedReader br = new BufferedReader(new FileReader(this.fileSpecFile));
            while ((entry = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(entry, "=");
                if (st.countTokens() < 2) continue;
                String ident = st.nextToken().trim();
                String value = st.nextToken().replace('\'', ' ').trim();
                String fname = new File(value).getName();
                String path = new File(value).getParent();
                super.updateFile(ident, fname, "filename", fname);
                super.updateFile(ident, fname, "relative_path", path);
                this.logger.debug((Object)("path, fname: " + fname + ", " + path));
            }
            br.close();
        }
        catch (Exception e) {
            this.logger.error((Object)("failed read from: " + this.fileSpecFile.getAbsolutePath()));
            e.printStackTrace();
        }
    }

    public String getBaseDirectory() {
        return this.fileSpecFile.getParent();
    }
}

