/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal.preparationpanel;

import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.FBZData;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.Kpoints;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.GUIBootButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class KpointSamplingPanel
extends ProjectManipulator {
    private Logger logger = Logger.getLogger((String)KpointSamplingPanel.class.getName());

    public KpointSamplingPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void init() {
        this.add(new KsampPanel(this.projectInfo.getInputInterface()));
    }

    private void bootFBZViewer() {
        String dir = this.projectInfo.getProjectDirectory();
        double[][] reclat = PhaseUtils.getReciprocalLatticeFrom(this.projectInfo.getInputInterface());
        try {
            FBZData data = new FBZData();
            data.reciprocalLattice = reclat;
            data.baseDir = dir;
            new FBZ(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class KsampPanel
    extends PhaseInputItems {
        KsampPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        @Override
        public void createGUI() {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setSize(500, 250);
            String accuracy = "accuracy.";
            JPanel p_ksample = new JPanel();
            p_ksample.setLayout(new FlowLayout(0));
            String ksamp = String.valueOf(accuracy) + "ksampling.";
            String[] specMethod = new String[]{"accuracy.ksampling.method"};
            String[] methodChoice = new String[]{this.NO_SELECTION, "monk", "mesh", "file", "gamma", "directin"};
            ChoicePanelPhase method = new ChoicePanelPhase(specMethod, this.inputInterface, "Method", methodChoice, this);
            p_ksample.add(method);
            JPanel panelbtn = new JPanel();
            panelbtn.setLayout(new GridLayout(2, 1));
            JButton panelbandkpt = new JButton("band_kpoints.pl");
            JButton fbzButton = new JButton("FBZ");
            fbzButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KpointSamplingPanel.this.bootFBZViewer();
                }
            });
            panelbtn.add(fbzButton);
            Object[] argk = new Object[1];
            GUIBootButton btnkdirect = new GUIBootButton("edit kpoints", this.inputInterface, Kpoints.class, (ActionListener)this);
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            method.registerDisabableGUI(nArray, btnkdirect);
            int[] nArray2 = new int[5];
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 4;
            nArray2[4] = 5;
            method.registerDisabableGUI(nArray2, fbzButton);
            panelbtn.add(btnkdirect);
            p_ksample.add(panelbtn);
            JPanel ptable = new JPanel();
            ptable.setLayout(new BoxLayout(ptable, 1));
            String[] kmeshSpec = new String[]{String.valueOf(ksamp) + "mesh"};
            TableForInputInterface kmeshTable = new TableForInputInterface(kmeshSpec, this.inputInterface, null, this);
            kmeshTable.getModel().addTableModelListener(this);
            JScrollPane scrPaneKmesh = new JScrollPane();
            scrPaneKmesh.getViewport().setView(kmeshTable.getPanel());
            ptable.add(scrPaneKmesh);
            int icol = kmeshTable.getModel().getColumnCount();
            int[] intarray = new int[]{3, 4, 5};
            int j = 0;
            while (j < icol) {
                DefaultCellEditor editor = (DefaultCellEditor)kmeshTable.getColumnModel().getColumn(j).getCellEditor();
                method.registerDisabableGUI(intarray, (JComponent)editor.getComponent());
                ++j;
            }
            String[] ksampIdent = new String[]{String.valueOf(ksamp) + "kshift"};
            TableForInputInterface kshiftTable = new TableForInputInterface(ksampIdent, this.inputInterface, null, this);
            JScrollPane scrPaneKshift = new JScrollPane();
            scrPaneKshift.getViewport().setView(kshiftTable.getPanel());
            ptable.add(scrPaneKshift);
            icol = kshiftTable.getModel().getColumnCount();
            int[] intshift = new int[]{2, 3, 4, 5};
            int j2 = 0;
            while (j2 < icol) {
                DefaultCellEditor editor = (DefaultCellEditor)kshiftTable.getColumnModel().getColumn(j2).getCellEditor();
                method.registerDisabableGUI(intshift, (JComponent)editor.getComponent());
                ++j2;
            }
            JPanel p_ksample_all = new JPanel();
            p_ksample_all.setBorder(new TitledBorder("K point sampling"));
            p_ksample_all.setLayout(new BoxLayout(p_ksample_all, 0));
            p_ksample_all.add(p_ksample);
            p_ksample_all.add(ptable);
            p.add(p_ksample_all);
            String[] specNumBnd = new String[]{String.valueOf(accuracy) + "num_bands"};
            InputPanelPhase numbands = new InputPanelPhase(specNumBnd, this.inputInterface, "num. bands", 0, 7, this);
            p.add(numbands);
            JPanel p_smear = new JPanel();
            p_smear.setLayout(new GridLayout(1, 2, 1, 1));
            String[] specSmear = new String[]{String.valueOf(accuracy) + "smearing.method"};
            String[] smearChoice = new String[]{this.NO_SELECTION, "parabolic", "tetrahedron"};
            ChoicePanelPhase smear = new ChoicePanelPhase(specSmear, this.inputInterface, "Method", smearChoice, this);
            p_smear.add(smear);
            String[] specWidth = new String[]{String.valueOf(accuracy) + "smearing.width"};
            InputPanelPhase width = new InputPanelPhase(specWidth, this.inputInterface, "width", 4, 7, this);
            p_smear.add(width);
            int[] nArray3 = new int[2];
            nArray3[1] = 2;
            smear.registerDisabableGUI(nArray3, width);
            p_smear.setBorder(new TitledBorder("Smearing"));
            p.add(p_smear);
            JPanel p_init = new JPanel();
            p_init.setLayout(new GridLayout(1, 2, 1, 1));
            String[] initWFSpec = new String[]{String.valueOf(accuracy) + "initial_wavefunctions"};
            String[] initWFChoice = new String[]{this.NO_SELECTION, "Matrix_diagon", "Random_numbers"};
            ChoicePanelPhase initWF = new ChoicePanelPhase(initWFSpec, this.inputInterface, "wave function", initWFChoice, this);
            String[] matdiagonCutoffSpec = new String[]{String.valueOf(accuracy) + "matrix_diagon.cutoff_wf"};
            InputPanelPhase matdiagon = new InputPanelPhase(matdiagonCutoffSpec, this.inputInterface, "cutoff (matrix diagon)", 4, 7, this);
            p_init.add(initWF);
            p_init.add(matdiagon);
            int[] nArray4 = new int[2];
            nArray4[1] = 2;
            initWF.registerDisabableGUI(nArray4, matdiagon);
            String[] initCDSpec = new String[]{String.valueOf(accuracy) + "initial_charge_density"};
            String[] initCDChoice = new String[]{"Gauss"};
            ChoicePanelPhase initCD = new ChoicePanelPhase(initCDSpec, this.inputInterface, "charge density", initCDChoice, this);
            p_init.add(initCD);
            p_init.setBorder(new TitledBorder("Initial"));
            p.add(p_init);
            this.add(p);
        }
    }
}

