/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal.inputcheck;

import ciss.phase_viewer.input.PhaseInputChecker;
import java.io.File;
import org.apache.log4j.Logger;

public class ChargeChecker
extends PhaseInputChecker {
    private Logger logger = Logger.getLogger((String)ChargeChecker.class.getName());

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public String getName() {
        return "charge";
    }

    @Override
    public String getDescription() {
        return "check charge file.";
    }

    @Override
    public String getCandidate() {
        return "";
    }

    @Override
    public boolean fixInput() {
        return true;
    }

    @Override
    public int doCheck() {
        String path = this.getFilePath("F_CHGT");
        if (path == null) {
            this.state = -1;
            this.message = "the name for the F_CHGT file is not specified.\n";
            this.message = String.valueOf(this.message) + "this is OK if it resides on the same directory\n";
            this.message = String.valueOf(this.message) + "and if you are using the default file name 'nfchgt.data'.";
            return this.state;
        }
        File file = new File(path);
        this.logger.debug((Object)("charge file: " + file.getAbsolutePath()));
        this.logger.debug((Object)("isAbsolute: " + file.isAbsolute()));
        this.logger.debug((Object)("does it exist? " + file.exists()));
        if (file.exists() && file.length() != 0L) {
            this.state = 0;
            this.message = "F_CHGT file exists \nand its file size is not zero.";
            return this.state;
        }
        if (file.exists() && file.length() == 0L) {
            this.state = -2;
            this.message = "F_CHGT file exists, \nbut its file size is zero.\ncheck your SCF calculation.";
        } else if (!file.exists()) {
            this.state = -2;
            this.message = "F_CHGT file does not exist.";
        }
        return this.state;
    }
}

