/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.input.InputCheckerGUI;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.UndoRedoEvent;
import ciss.phase_viewer.inputinterface.UndoRedoListener;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.TabbedProjectManipulator;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public abstract class PreparationPanelBase
extends ProjectManipulator
implements UndoRedoListener {
    private Logger logger = Logger.getLogger((String)PreparationPanelBase.class.getName());
    protected InputInterface inputInterface;
    private JButton btnSave;
    private JButton btnUndo;
    private JButton btnRedo;
    private JButton btnCheck;
    private JPanel jPanel5;

    public PreparationPanelBase(ProjectInfo projectInfo) {
        super(projectInfo);
        this.initComponents();
    }

    protected abstract URL getTabbedManipulatorSpec();

    @Override
    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.inputInterface = this.projectInfo.getInputInterface();
        URL urltab = this.getTabbedManipulatorSpec();
        this.add(new TabbedProjectManipulator(urltab, this.projectInfo));
        this.add(this.createButtons());
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.btnSave = new JButton("save");
        this.btnUndo = new JButton("undo");
        this.btnRedo = new JButton("redo");
        JButton btnEdit = new JButton("editor");
        this.btnUndo.setEnabled(false);
        this.btnRedo.setEnabled(false);
        p.add(btnEdit);
        p.add(this.btnSave);
        p.add(this.btnUndo);
        this.inputInterface.addUndoRedoListener(this);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nfinp = String.valueOf(PreparationPanelBase.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + PreparationPanelBase.this.projectInfo.getChaseFileManager().getFile("F_INP").getFileName();
                ProjectBrowserUtils.bootTextViewer(nfinp);
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nfinp = String.valueOf(PreparationPanelBase.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + PreparationPanelBase.this.projectInfo.getChaseFileManager().getFile("F_INP").getFileName();
                PreparationPanelBase.this.inputInterface.saveTo(new File(nfinp));
                PreparationPanelBase.this.projectInfo.getChaseFileManager().save();
            }
        });
        this.btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreparationPanelBase.this.inputInterface.undo();
            }
        });
        return p;
    }

    private void bootInputChecker() {
        InputCheckerGUI gui = new InputCheckerGUI(this.getInputCheckerProps(), this.projectInfo.getInputInterface());
    }

    protected abstract Properties getInputCheckerProps();

    @Override
    public void undoRedoStateChanged(UndoRedoEvent e) {
        this.logger.debug((Object)("at undoRedoStateChanged: size of undostack, redostack: " + e.getUndoStackCount() + " " + e.getRedoStackCount()));
        this.logger.debug((Object)("source: " + e.getSource()));
        this.btnUndo.setEnabled(e.getUndoStackCount() != 0);
        this.btnRedo.setEnabled(e.getRedoStackCount() != 0);
    }

    @Override
    public boolean postProcess() {
        if (!this.inputInterface.stateChanged() || this.projectInfo.getParent() == null || !this.projectInfo.getParent().isVisible()) {
            return true;
        }
        int res = JOptionPane.showOptionDialog(this, "modified buffer exists... exit without saving?", "confirmation", 1, 1, null, new String[]{"yes", "no", "save"}, "save");
        if (res == 0) {
            this.inputInterface.setState(false);
            return true;
        }
        if (res == 1) {
            return false;
        }
        if (res == 2) {
            this.inputInterface.save();
            return true;
        }
        return true;
    }

    @Override
    public void initializeProject() {
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.setLayout(new GridLayout(1, 0));
        this.setBorder(new TitledBorder(null, "Preparation panel", 0, 0, new Font("MS Sans Serif", 0, 11), new Color(0, 0, 102)));
    }
}

