/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.ProjectManipulatorBase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInitializer;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutGeneralPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutPostPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutSCFPanel;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.scripting.ScriptWrapper;
import java.io.File;
import java.net.URL;

public class PhaseManipulator
extends ProjectManipulatorBase {
    private String scriptDir = String.valueOf(baseScriptDir) + "phase";
    private ChaseFileManager cfManager;
    private URL phaseSpec = PhaseConstants.FILEINFO_PHASE;

    public PhaseManipulator(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public boolean createDefaultScript() {
        ScriptWrapper[] defaults = this.getDefaultScripts();
        int i = 0;
        while (i < defaults.length) {
            String name = new File(defaults[i].getPath()).getName();
            try {
                ExternalProgramExecuter.copy(String.valueOf(this.scriptDir) + System.getProperty("file.separator") + name, defaults[i].getPath());
            }
            catch (Exception exc) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ScriptWrapper[] getDefaultScripts() {
        ScriptWrapper[] defaults = new ScriptWrapper[REGISTERED_SCRIPT_TYPE.length];
        String prefix = "submit.";
        String FS = System.getProperty("file.separator");
        int i = 0;
        while (i < REGISTERED_SCRIPT_TYPE.length) {
            defaults[i] = new ScriptWrapper(String.valueOf(this.baseDir) + FS + prefix + REGISTERED_SCRIPT_TYPE[i], REGISTERED_SCRIPT_TYPE[i]);
            ++i;
        }
        return defaults;
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void initializeProject(ProjectDirBrowserNode node) {
        PhaseInitializer init = new PhaseInitializer(this.projectInfo, this, node);
        init.runWizard();
    }

    @Override
    protected URL getSubSelectorURL() {
        return this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/manipulator_sub_selector_properties.xml");
    }

    @Override
    protected Class[] getStdoutGUIs() {
        return new Class[]{StdoutGeneralPanel.class, StdoutSCFPanel.class, StdoutPostPanel.class};
    }

    @Override
    protected URL getProgramDescriptionURL() {
        return this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/intropanel/phase_intro.htm");
    }

    @Override
    protected ChaseFileManager getChaseFileManager() {
        File fnamesData = new File(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "file_names.data");
        if (this.cfManager == null) {
            this.cfManager = new PhaseFileManager(this.phaseSpec, fnamesData);
        }
        this.cfManager.setFileSpecFile(fnamesData);
        return this.cfManager;
    }

    @Override
    protected String getType() {
        this.getChaseFileManager();
        return this.cfManager.getName();
    }
}

