/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.movie;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.movie.MovieViewer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuBar;
import org.apache.log4j.Logger;

class MovieViewerMenuBar
extends JMenuBar {
    private static Logger logger = Logger.getLogger((String)MovieViewerMenuBar.class.getName());
    private MovieViewer parent;

    protected MovieViewerMenuBar(MovieViewer parent) {
        this.parent = parent;
        this.createMenu();
    }

    private void createMenu() {
        this.add(this.fileMenu());
    }

    private MyJMenu fileMenu() {
        MyJMenu file = new MyJMenu("File", 70, false);
        MyJMenuItem open = new MyJMenuItem("open", 79);
        file.add(open);
        MyJMenuItem exit = new MyJMenuItem("exit", 88);
        file.add(exit);
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String movieFile = MovieViewerMenuBar.this.getFileName();
                if (movieFile != null && new File(movieFile).exists()) {
                    logger.debug((Object)("setting movie file: " + movieFile));
                    MovieViewerMenuBar.this.parent.setMovieFile("file:" + movieFile);
                } else {
                    logger.warn((Object)("couldn't open movie file: " + movieFile));
                }
            }
        });
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieViewerMenuBar.this.parent.dispose();
            }
        });
        return file;
    }

    private String getFileName() {
        ChaseFileChooser fdlg = new ChaseFileChooser("media");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("movie file");
        fdlg.setFileSelectionMode(0);
        if (fdlg.showDialog(this.parent, "Select") != 0) {
            return null;
        }
        return fdlg.getSelectedFile().getAbsolutePath();
    }
}

