/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.jobcontrol;

import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.jobcontrol.JobControllerElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.remotehostexecuter.BatchFileTransferer;
import ciss.phase_viewer.ssh.remotehostexecuter.JobExecuter;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class JobController {
    private static Logger logger = Logger.getLogger((String)JobController.class.getName());
    public static String JOBCONTROL_FILE = "phase-viewer.xml";
    public static String ROOT = "project";
    public static String JOBCONTROL = "jobcontrol";
    private String baseDir;

    public JobController(String baseDir) {
        this.baseDir = baseDir;
    }

    public static Document getJobControlDocument(ProjectInfo projectInfo, JobControllerElement element) {
        Element jobcontrol;
        String dir = projectInfo.getProjectDirectory();
        Document doc = projectInfo.getProjectPropertyDocument();
        if (doc == null) {
            File xmlfile = new File(String.valueOf(dir) + System.getProperty("file.separator") + JOBCONTROL_FILE);
            doc = XMLUtils.getDocumentFromFile(xmlfile);
        }
        if (!doc.hasRootElement()) {
            Element root = JobController.getRootElement();
            doc.setRootElement(root);
        }
        if ((jobcontrol = doc.getRootElement().getChild(JOBCONTROL)) == null) {
            jobcontrol = new Element(JOBCONTROL);
            doc.getRootElement().addContent((Content)jobcontrol);
        }
        if (!element.readJobControlDocument(doc)) {
            logger.debug((Object)("failed to read job-control element : " + element.getClass().getName()));
            element.initJobControlDocument(doc);
            XMLUtils.saveDocumentTo(doc, String.valueOf(dir) + System.getProperty("file.separator") + JOBCONTROL_FILE);
            element.readJobControlDocument(doc);
        }
        return doc;
    }

    public static void saveJobControlFile(ProjectInfo projectInfo) {
        Document doc = projectInfo.getProjectPropertyDocument();
        String baseDir = projectInfo.getProjectDirectory();
        XMLUtils.saveDocumentTo(doc, String.valueOf(baseDir) + System.getProperty("file.separator") + JOBCONTROL_FILE);
    }

    public static void saveJobControlFile(String dir, Document doc) {
        File jobcont = new File(String.valueOf(dir) + System.getProperty("file.separator") + JOBCONTROL_FILE);
        if (jobcont.exists() && jobcont.canWrite()) {
            XMLUtils.saveDocumentTo(doc, String.valueOf(dir) + System.getProperty("file.separator") + JOBCONTROL_FILE);
        }
    }

    public static Element getRootElement() {
        Element element = new Element(ROOT);
        return element;
    }

    public static boolean execute(ProjectInfo projectInfo, HostInfo hostInfo) {
        logger.info((Object)"start job execution");
        BatchFileTransferer batchTransfer = new BatchFileTransferer(projectInfo, hostInfo);
        JobExecuter executer = new JobExecuter(projectInfo, hostInfo, batchTransfer);
        boolean ret = executer.execute();
        return ret;
    }
}

