/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface.inputinterfacetable;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import ciss.phase_viewer.jdom.XMLUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class InputInterfaceTableSpecManager
implements Serializable {
    private Logger logger = Logger.getLogger((String)InputInterfaceTableSpecManager.class.getName());
    private InputInterface parent;
    private InputInterfaceTableSpec[] tableSpecs;

    public InputInterfaceTableSpecManager(URL url, InputInterface parent) {
        this.parent = parent;
        this.tableSpecs = this.createTableSpecFrom(url);
    }

    public void setInputInterface(InputInterface parent) {
        this.parent = parent;
        this.logger.debug((Object)("parent: " + parent));
    }

    public InputInterface getInputInterface() {
        return this.parent;
    }

    public InputInterfaceTableSpec[] getTableSpecs() {
        return this.tableSpecs;
    }

    public InputInterfaceTableSpec getTableSpec(String ID) {
        if (this.tableSpecs == null) {
            return null;
        }
        int i = 0;
        while (i < this.tableSpecs.length) {
            if (this.tableSpecs[i].getID().equalsIgnoreCase(ID)) {
                return this.tableSpecs[i];
            }
            ++i;
        }
        return null;
    }

    public InputInterfaceTableSpec getTableSpec(String ID, int index) {
        if (this.tableSpecs == null) {
            return null;
        }
        int count = 0;
        int i = 0;
        while (i < this.tableSpecs.length) {
            if (this.tableSpecs[i].getID().equalsIgnoreCase(ID)) {
                if (count == index) {
                    return this.tableSpecs[i];
                }
                ++count;
            }
            ++i;
        }
        return null;
    }

    private InputInterfaceTableSpec[] createTableSpecFrom(URL url) {
        Document doc = XMLUtils.getDocumentFromURL(url);
        Element root = doc.getRootElement();
        List columns = root.getChildren();
        if (columns == null) {
            this.logger.error((Object)"invalid specification for table spec.");
            return null;
        }
        InputInterfaceTableSpec[] ret = new InputInterfaceTableSpec[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            ret[i] = this.createTableSpec((Element)columns.get(i));
            ++i;
        }
        return ret;
    }

    private InputInterfaceTableSpec createTableSpec(Element element) {
        InputInterfaceTableSpec spec = new InputInterfaceTableSpec(element, this);
        return spec;
    }
}

