/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InputInterfacePrimitiveEntry
extends InputInterfaceEntry
implements Serializable {
    private Logger logger = Logger.getLogger((String)InputInterfacePrimitiveEntry.class.getName());
    private String value = "";
    private String unit = "";
    private Vector listeners = new Vector();
    private boolean isDoubleQuoted = false;

    public InputInterfacePrimitiveEntry() {
    }

    public InputInterfacePrimitiveEntry(String name, String value, String unit) {
        super(name);
        this.value = value;
        this.unit = unit;
    }

    public void setDoubleQuoted(boolean isDoubleQuoted) {
        this.isDoubleQuoted = isDoubleQuoted;
    }

    public boolean isDoubleQuoted() {
        return this.isDoubleQuoted;
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value.trim();
    }

    public String getValueDelimitedBy() {
        return this.getValueDelimitedBy(":");
    }

    public String getValueDelimitedBy(String delimiter) {
        String[] array = this.value.split(delimiter);
        if (array == null || array.length == 0 || array[0] == null) {
            return this.value.trim();
        }
        return array[0].trim();
    }

    public String getUnit() {
        return this.unit.trim();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isValueSet() {
        return this.value.trim().length() != 0;
    }

    @Override
    public int getEntryType() {
        return 0;
    }

    public String toString() {
        return "name: " + this.name + " value: " + this.value + " unit: " + this.unit + " isDQ? " + String.valueOf(this.isDoubleQuoted);
    }

    public InputInterfaceEntry getCopy() {
        return new InputInterfacePrimitiveEntry(new String(this.name), new String(this.value), new String(this.unit));
    }

    @Override
    public boolean equals(InputInterfaceEntry entry) {
        if (!(entry instanceof InputInterfacePrimitiveEntry)) {
            return false;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
        return pentry.getName().equals(this.name) && pentry.getValue().equals(this.value) && pentry.getUnit().equals(this.unit);
    }

    @Override
    public void saveState() {
        this.logger.debug((Object)("saving state: name, value, and unit" + this.name + " " + this.value + " " + this.unit));
        InputInterfacePrimitiveEntry buff = new InputInterfacePrimitiveEntry(new String(this.name), new String(this.value), new String(this.unit));
        this.undoStack.push(buff);
    }

    @Override
    public void undo() {
        InputInterfacePrimitiveEntry old = this.doIt(this.undoStack);
        if (old != null) {
            this.redoStack.push(old);
        }
    }

    @Override
    public void redo() {
        InputInterfacePrimitiveEntry old = this.doIt(this.redoStack);
        if (old != null) {
            this.undoStack.push(old);
        }
    }

    private InputInterfacePrimitiveEntry doIt(Stack stack) {
        if (stack.empty()) {
            this.logger.info((Object)"stack empty.");
            return null;
        }
        InputInterfacePrimitiveEntry old = (InputInterfacePrimitiveEntry)stack.pop();
        if (old == null) {
            return null;
        }
        this.name = old.getName();
        this.value = old.getValue();
        this.unit = old.getUnit();
        return old;
    }
}

