/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.export;

import ciss.phase_viewer.common.Drawable;
import ciss.phase_viewer.common.SVGExporter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.freehep.util.export.ExportFileType;

public class SVGExportFileType
extends ExportFileType {
    private Logger logger = Logger.getLogger((String)SVGExportFileType.class.getName());
    private Drawable drawable;

    public SVGExportFileType(Drawable drawable) {
        this.drawable = drawable;
    }

    public String[] getMIMETypes() {
        return new String[]{"svg"};
    }

    public String[] getExtensions() {
        return new String[]{"svg", "SVG"};
    }

    public String getDescription() {
        return "scalable vector graphics ";
    }

    public void exportToFile(File file, Component[] component, Component component0, Properties properties, String string) throws IOException {
        if (component == null || component.length == 0) {
            return;
        }
        this.exportToFile(file, component[0], component0, properties, string);
    }

    public void exportToFile(File file, Component component, Component component0, Properties properties, String string) throws IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        SVGExporter.g2DtoSVG(this.drawable, file, width, height);
    }

    public void exportToFile(OutputStream outputStream, Component[] component, Component component0, Properties properties, String string) throws IOException {
        if (component == null || component.length == 0) {
            return;
        }
        this.exportToFile(outputStream, component[0], component0, properties, string);
    }

    public void exportToFile(OutputStream outputStream, Component component, Component component0, Properties properties, String string) throws IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        SVGExporter.g2DtoSVG(this.drawable, outputStream, width, height);
    }
}

