/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.filebrowser.FileBrowserTree;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import com.jcraft.jsch.ChannelSftp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

class ComboBoxFileBrowser
extends JComboBox {
    private static Logger logger = Logger.getLogger((String)ComboBoxFileBrowser.class.getName());
    private RemoteFile root;
    private FileBrowserTree tree;
    private ChannelSftp c;

    protected ComboBoxFileBrowser(FileBrowserTree tree, ChannelSftp c) {
        this.tree = tree;
        this.c = c;
        this.createCombo();
    }

    private void addListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteFile newRoot = new RemoteFile((String)ComboBoxFileBrowser.this.getSelectedItem(), ComboBoxFileBrowser.this.c);
                newRoot.isRoot(true);
                ComboBoxFileBrowser.this.tree.setNewRoot(newRoot);
                ComboBoxFileBrowser.this.createCombo();
            }
        });
    }

    private void createCombo() {
        this.removeAllItems();
        this.root = this.tree.getCurrentRoot();
        if (this.root != null) {
            RemoteFile[] parents = this.getParents(this.root);
            String[] itemStrings = null;
            if (parents != null && parents.length != 0) {
                itemStrings = new String[parents.length];
                int i = 0;
                while (i < parents.length) {
                    logger.debug((Object)("parent no. " + i + " is " + parents[i]));
                    itemStrings[i] = parents[i].getAbsolutePath();
                    ++i;
                }
                i = parents.length - 1;
                while (i >= 0) {
                    logger.debug((Object)("adding item no. " + i + ", elem " + itemStrings[i]));
                    this.addItem(itemStrings[i]);
                    --i;
                }
            }
            this.setSelectedIndex(this.getItemCount() - 1);
            this.addListener();
            this.setVisible(false);
            this.setVisible(true);
            this.revalidate();
        }
    }

    private RemoteFile[] getParents(RemoteFile base) {
        String dirnow = new String(base.getAbsolutePath());
        RemoteFile parent = base;
        Vector<RemoteFile> fileVector = new Vector<RemoteFile>();
        int parentCount = 0;
        fileVector.addElement(parent);
        while (true) {
            parent = (RemoteFile)parent.getParentFile();
            if (++parentCount >= 100 || parent == null) break;
            logger.debug((Object)("parentdir: " + parent));
            fileVector.addElement(parent);
        }
        logger.debug((Object)("num. parents: " + parentCount));
        RemoteFile[] retFile = new RemoteFile[fileVector.size()];
        int i = 0;
        while (i < fileVector.size()) {
            retFile[i] = (RemoteFile)fileVector.get(i);
            ++i;
        }
        return retFile;
    }
}

