/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.file.FileTransferInfoEditorPanel;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.DefaultScriptCreator;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.jobcontrol.JobControllerElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostSelectorCombo;
import ciss.phase_viewer.ssh.remotehostexecuter.BatchFileTransferer;
import ciss.phase_viewer.ssh.sftp.SftpClient;
import ciss.phase_viewer.ssh.terminal.Terminal;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class FileTransferPanel
extends JPanel
implements JobControllerElement {
    private Logger logger = Logger.getLogger((String)FileTransferPanel.class.getName());
    private ProjectInfo projectInfo;
    private Document doc;
    private HostSelectorCombo hostSelector;
    private JButton transfer;
    private JButton upl;
    private JButton down;
    private JButton ssh;
    private JButton sftp;
    private String scriptName = "file_transfer.bsh";
    private String targethost = "targethost";

    public FileTransferPanel(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.init();
    }

    public HostInfo getSelectedHost() {
        return this.hostSelector.getSelectedHost();
    }

    public void setSelectedHost(HostInfo info) {
        this.hostSelector.setSelectedItem(info.getName());
    }

    public void addActionListenerToHostSelector(ActionListener listener) {
        this.hostSelector.addActionListener(listener);
        this.copyJobScript();
        this.hostSelector.setSelectedIndex(this.hostSelector.getSelectedIndex());
    }

    private void runScript() {
        String sfile = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.scriptName;
        if (!new File(sfile).exists()) {
            return;
        }
        HashMap<String, Object> ma = new HashMap<String, Object>();
        ma.put("document", this.doc);
        ma.put("projectInfo", this.projectInfo);
        ScriptUtils.runScript(sfile, ma);
    }

    private void copyJobScript() {
        String hostName = "";
        try {
            hostName = this.hostSelector.getSelectedHost().getName();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        File scriptFile = new File(String.valueOf(DefaultScriptCreator.baseScriptDir) + this.projectInfo.getProjectType() + System.getProperty("file.separator") + "submit.sh." + hostName);
        if (!scriptFile.exists()) {
            scriptFile = new File(String.valueOf(DefaultScriptCreator.baseScriptDir) + this.projectInfo.getProjectType() + System.getProperty("file.separator") + "submit.sh");
        }
        try {
            ExternalProgramExecuter.copyBinary(scriptFile.getAbsolutePath(), String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "submit.sh");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.setBorder(new TitledBorder("file transfer"));
        this.logger.debug((Object)"at FileTransferPanel.init()");
        this.hostSelector = new HostSelectorCombo();
        this.transfer = new JButton("transfer scheme");
        this.upl = new JButton("upload");
        this.down = new JButton("download");
        this.ssh = new JButton("ssh");
        this.sftp = new JButton("sftp");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.hostSelector);
        panel.add(this.transfer);
        panel.add(this.upl);
        panel.add(this.down);
        panel.add(this.ssh);
        panel.add(this.sftp);
        this.doc = JobController.getJobControlDocument(this.projectInfo, this);
        this.logger.debug((Object)"got document");
        this.runScript();
        this.hostSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String orgHost = FileTransferPanel.this.projectInfo.getHostInfo().getName();
                FileTransferPanel.this.projectInfo.getChaseFileManager().setHostInfo(FileTransferPanel.this.hostSelector.getSelectedHost());
                FileTransferPanel.this.transfer.setEnabled(!FileTransferPanel.this.hostSelector.getSelectedHost().isLocalHost());
                FileTransferPanel.this.upl.setEnabled(!FileTransferPanel.this.hostSelector.getSelectedHost().isLocalHost());
                FileTransferPanel.this.down.setEnabled(!FileTransferPanel.this.hostSelector.getSelectedHost().isLocalHost());
                FileTransferPanel.this.ssh.setEnabled(!FileTransferPanel.this.hostSelector.getSelectedHost().isLocalHost());
                FileTransferPanel.this.sftp.setEnabled(!FileTransferPanel.this.hostSelector.getSelectedHost().isLocalHost());
                FileTransferPanel.this.projectInfo.setHostInfo(FileTransferPanel.this.hostSelector.getSelectedHost());
                FileTransferPanel.this.saveToDisk();
                if (!orgHost.equals(FileTransferPanel.this.hostSelector.getSelectedHost().getName())) {
                    FileTransferPanel.this.copyJobScript();
                }
            }
        });
        this.transfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransferInfoEditorPanel fip = new FileTransferInfoEditorPanel(FileTransferPanel.this.projectInfo.getChaseFileManager());
            }
        });
        this.sftp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SftpClient sfc = new SftpClient(FileTransferPanel.this.hostSelector.getSelectedHost(), true);
            }
        });
        this.ssh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Terminal term = new Terminal(FileTransferPanel.this.hostSelector.getSelectedHost(), "cd " + FileTransferPanel.this.projectInfo.getTargetDirectory());
            }
        });
        this.upl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileTransferPanel.this.hostSelector.getSelectedHost().isLocalHost()) {
                    FileTransferPanel.this.logger.info((Object)"no need to transfer file for host 'localhost'.");
                    return;
                }
                BatchFileTransferer bft = new BatchFileTransferer(FileTransferPanel.this.projectInfo, FileTransferPanel.this.hostSelector.getSelectedHost());
                bft.upload();
            }
        });
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileTransferPanel.this.hostSelector.getSelectedHost().isLocalHost()) {
                    FileTransferPanel.this.logger.info((Object)"no need to transfer file for host 'localhost'.");
                    return;
                }
                BatchFileTransferer bft = new BatchFileTransferer(FileTransferPanel.this.projectInfo, FileTransferPanel.this.hostSelector.getSelectedHost());
                bft.download();
            }
        });
        this.add((Component)panel, "Center");
        this.hostSelector.setSelectedIndex(this.hostSelector.getSelectedIndex());
    }

    private void saveToDisk() {
        this.projectInfo.setTargetDirectory(this.hostSelector.getSelectedHost());
        Element host = this.doc.getRootElement().getChild(JobController.JOBCONTROL).getChild(this.targethost);
        if (host == null) {
            return;
        }
        host.setText(MyElement.encode(this.hostSelector.getSelectedHost().getName()));
        Element env = host.getChild("env");
        if (env == null || env.getChildren().size() == 0) {
            env = new Element("env");
            host.addContent((Content)env);
        }
        this.setHostEnvs(env);
        JobController.saveJobControlFile(this.projectInfo.getProjectDirectory(), this.doc);
    }

    @Override
    public boolean readJobControlDocument(Document doc) {
        this.logger.debug((Object)"at readJobControlDocument");
        Element root = doc.getRootElement().getChild(JobController.JOBCONTROL);
        Element elem = root.getChild(this.targethost);
        if (elem == null) {
            this.logger.debug((Object)"invalid element");
            return false;
        }
        this.logger.debug((Object)"selecting hostSelector");
        this.hostSelector.setSelectedItem(MyElement.decode(elem.getTextTrim()));
        this.logger.debug((Object)"ok.");
        return true;
    }

    @Override
    public void initJobControlDocument(Document doc) {
        Element element = new Element(this.targethost);
        element.setText(this.hostSelector.getSelectedHost().getName());
        doc.getRootElement().getChild(JobController.JOBCONTROL).addContent((Content)element);
        Element env = new Element("env");
        this.setHostEnvs(env);
        element.addContent((Content)env);
    }

    private void setHostEnvs(Element env) {
        TaggedString[] hostEnvs = this.getHostEnvs();
        if (hostEnvs == null || hostEnvs.length == 0) {
            return;
        }
        int i = 0;
        while (i < hostEnvs.length) {
            Element elem = new Element(hostEnvs[i].getTag());
            elem.setText(MyElement.encode(hostEnvs[i].getValue()));
            List envList = env.getChildren();
            if (envList == null) {
                env.addContent((Content)elem);
            } else {
                boolean found = false;
                int j = 0;
                while (j < envList.size()) {
                    Element el = (Element)envList.get(j);
                    if (el.getName().equals(hostEnvs[i].getTag())) {
                        el.setText(MyElement.encode(hostEnvs[i].getValue()));
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    env.addContent((Content)elem);
                }
            }
            ++i;
        }
    }

    private TaggedString[] getHostEnvs() {
        Vector<TaggedString> vec = new Vector<TaggedString>();
        vec.addElement(new TaggedString("targetdir", this.projectInfo.getTargetDirectory()));
        vec.addElement(new TaggedString("bindir", this.hostSelector.getSelectedHost().getProperty("bindir")));
        vec.addElement(new TaggedString("javadir", this.hostSelector.getSelectedHost().getProperty("javadir")));
        vec.addElement(new TaggedString("mpidir", this.hostSelector.getSelectedHost().getProperty("mpidir")));
        String win = "false";
        if (this.hostSelector.getSelectedHost().isLocalHost() && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            win = "true";
        }
        vec.addElement(new TaggedString("windows", win));
        Object[] envs = new TaggedString[vec.size()];
        vec.copyInto(envs);
        return envs;
    }
}

