/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.PPOrder;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.settings.PropertyPanel;
import ciss.phase_viewer.ssh.hosts.HostList;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class Utils {
    private static Logger logger = Logger.getLogger((String)Utils.class.getName());
    private static String FS = System.getProperty("file.separator");
    public static String NO_CANDIDATE = "(no candidate)";
    private static String[] defaultIgnoreDir = new String[]{".svn"};

    private Utils() {
    }

    public static final int getDirSize(File dir) {
        int size = 0;
        if (!dir.isDirectory()) {
            return size;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            size = files[i].isDirectory() ? (size += Utils.getDirSize(files[i])) : (int)((long)size + files[i].length());
            ++i;
        }
        return size;
    }

    public static PrintWriter getPrintWriter(String fileName) {
        return Utils.getPrintWriter(fileName, false);
    }

    public static PrintWriter getPrintWriter(String fileName, boolean append) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(fileName, append));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return writer;
    }

    public static BufferedReader getReader(String fileName) {
        if (!new File(fileName).exists()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return reader;
    }

    public static String getFileName(String ident, String dir) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!dir.endsWith(System.getProperty("file.separator"))) {
            dir = String.valueOf(dir) + System.getProperty("file.separator");
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(dir) + "file_names.data"));
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] entry = line.split("=");
                if (entry == null || entry.length < 2) continue;
                String value = entry[1].replaceAll("'", "").trim();
                map.put(entry[0].trim(), new File(value).getName());
            }
            reader.close();
        }
        catch (Exception reader) {
            // empty catch block
        }
        String ret = (String)map.get(ident);
        return ret;
    }

    public static String getDefaultPPDir() {
        return String.valueOf(HostList.getHostList().getHostInfo("localhost").getProperty("basedir")) + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "pseudopotential";
    }

    public static void bootTextViewer(String textfile) {
        File file = new File(textfile);
        if (file.exists()) {
            String editor = PropertiesManager.getGlobalProperties(0).getProperty("editor");
            if (editor == null) {
                logger.error((Object)"specify editor");
                return;
            }
            MyThread myThread = new MyThread(String.valueOf(Utils.getPathDQ(editor)) + " " + Utils.getPathDQ(textfile));
        } else {
            logger.error((Object)"file non-existent");
        }
    }

    public static boolean getBool(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().equalsIgnoreCase("on") || str.trim().equalsIgnoreCase("yes") || str.trim().equalsIgnoreCase("1") || str.trim().equalsIgnoreCase("true");
    }

    public static String firstLetterCaps(String input) {
        if (input == null) {
            return input;
        }
        String ret = input;
        char[] ch = input.toCharArray();
        if (ch != null && ch.length != 0) {
            ch[0] = Character.toUpperCase(ch[0]);
            ret = new String(ch, 0, ch.length);
        }
        return ret;
    }

    private static String getPath(String pathName) {
        String FS = System.getProperty("file.separator");
        Vector<String> pathVector = new Vector<String>();
        StringTokenizer st = new StringTokenizer(pathName, FS);
        while (st.hasMoreTokens()) {
            pathVector.addElement(st.nextToken());
        }
        String path = new String();
        Vector<String> newPathVector = new Vector<String>();
        String replaceString = "\\\\ ";
        int i = 0;
        while (i < pathVector.size()) {
            path = (String)pathVector.get(i);
            String newPath = path.replaceAll("\\s", replaceString);
            newPathVector.addElement(newPath);
            ++i;
        }
        if (newPathVector.size() == 1) {
            return (String)newPathVector.get(0);
        }
        path = new String();
        i = 0;
        while (i < newPathVector.size()) {
            path = String.valueOf(path) + FS + (String)newPathVector.get(i);
            ++i;
        }
        return path;
    }

    public static void toClipboard(String str) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(str);
        clip.setContents(ss, ss);
    }

    public static String stripNumber(String string) {
        char[] cha = string.toCharArray();
        Vector<Character> vec = new Vector<Character>();
        int i = 0;
        while (i < cha.length) {
            if (!Character.isDigit(cha[i])) {
                vec.addElement(new Character(cha[i]));
            }
            ++i;
        }
        char[] retchar = new char[vec.size()];
        int i2 = 0;
        while (i2 < retchar.length) {
            retchar[i2] = ((Character)vec.get(i2)).charValue();
            ++i2;
        }
        return new String(retchar);
    }

    public static String[] getPPCandidates(String element, String parentDir) {
        String strpp = Utils.getDefaultPPDir();
        if (parentDir != null) {
            strpp = parentDir;
        }
        File ppDir = new File(strpp);
        if (element == null || element.trim().length() == 0) {
            return new String[]{NO_CANDIDATE};
        }
        if (ppDir == null || !ppDir.isDirectory()) {
            return new String[]{NO_CANDIDATE};
        }
        String[] files = ppDir.list();
        Object[] ppOrder = new PPOrder[files.length];
        int i = 0;
        while (i < files.length) {
            ppOrder[i] = new PPOrder(files[i]);
            ++i;
        }
        Arrays.sort(ppOrder);
        Vector<String> ppfiles = new Vector<String>();
        int i2 = ppOrder.length - 1;
        while (i2 >= 0) {
            String comp = String.valueOf(((PPOrder)ppOrder[i2]).ppName.split("_")[0]) + "\\d*";
            if (element.matches(comp)) {
                ppfiles.addElement(((PPOrder)ppOrder[i2]).ppName);
            }
            --i2;
        }
        if (ppfiles.size() == 0) {
            return new String[]{NO_CANDIDATE};
        }
        Object[] ret = new String[ppfiles.size()];
        ppfiles.copyInto(ret);
        return ret;
    }

    public static String[] getPPCandidates(String element) {
        return Utils.getPPCandidates(element, null);
    }

    public static String getPathDQ(String pathName) {
        String osName = ConstParameters.osName;
        String ret = new String();
        ret = osName.toLowerCase().trim().startsWith("windows") ? "\"" + pathName + "\"" : Utils.getPath(pathName);
        return ret;
    }

    public static String getPathDQ(String pathName, boolean isWindows) {
        String osName = ConstParameters.osName;
        String ret = "";
        ret = isWindows ? "\"" + pathName + "\"" : Utils.getPath(pathName);
        return ret;
    }

    public static String stripDQ(String path) {
        return path.trim().replaceAll("\"", "");
    }

    public static boolean isDoubleQuoted(String foo) {
        return foo.trim().startsWith("\"") && foo.trim().endsWith("\"");
    }

    public static String stripSQ(String path) {
        return path.trim().replaceAll("'", "");
    }

    public static boolean stop(Object object) {
        boolean stopped = false;
        if (object instanceof JTable) {
            TableCellEditor editor = ((JTable)object).getCellEditor();
            try {
                editor.stopCellEditing();
                stopped = true;
            }
            catch (Exception exc) {
                stopped = false;
            }
        }
        return stopped;
    }

    public static boolean isNumber(String str) {
        boolean ret = true;
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        char[] ch = str.toCharArray();
        int i = 0;
        while (i < ch.length) {
            if (!Character.isDigit(ch[i])) {
                ret = false;
            }
            ++i;
        }
        return ret;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = Utils.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static int getTotalNumDir(File dir) {
        int numdir = 0;
        if (!dir.isDirectory()) {
            return numdir;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return 1;
        }
        int i = 0;
        while (i < files.length) {
            if (!files[i].getName().equals(".svn") && files[i].isDirectory()) {
                ++numdir;
                numdir += Utils.getTotalNumDir(files[i]);
            }
            ++i;
        }
        return numdir;
    }

    public static boolean copyDir(File fromDir, File toDir, boolean overwrite2) {
        if (!fromDir.isDirectory() || !toDir.isDirectory()) {
            logger.debug((Object)"both args must be directories");
            return false;
        }
        String fromDirName = fromDir.getName();
        File totoDir = new File(String.valueOf(toDir.getAbsolutePath()) + FS + fromDirName);
        totoDir.mkdir();
        File[] fromFiles = fromDir.listFiles();
        int i = 0;
        while (i < fromFiles.length) {
            if (!fromFiles[i].isDirectory()) {
                String name = fromFiles[i].getName();
                String copyName = String.valueOf(totoDir.getAbsolutePath()) + FS + name;
                if (!new File(copyName).exists() || overwrite2) {
                    try {
                        ExternalProgramExecuter.copyBinary(fromFiles[i].getAbsolutePath(), copyName);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        return false;
                    }
                }
            } else {
                boolean ignore = false;
                String name = fromFiles[i].getName();
                int j = 0;
                while (j < defaultIgnoreDir.length) {
                    if (name.equals(defaultIgnoreDir[j])) {
                        ignore = true;
                    }
                    ++j;
                }
                if (!ignore) {
                    Utils.copyDir(fromFiles[i], totoDir, overwrite2);
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean copyDir(File fromDir, File toDir) {
        return Utils.copyDir(fromDir, toDir, true);
    }

    public static boolean copyDir(File fromDir, File toDir, String newname) {
        if (!fromDir.isDirectory() || !toDir.isDirectory()) {
            logger.debug((Object)"both args must be directories");
            return false;
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpfromDir = new File(tmpDir + System.getProperty("file.separator") + fromDir.getName());
        Utils.deleteDir(tmpfromDir);
        if (!Utils.copyDir(fromDir, tmpDir)) {
            return false;
        }
        File toFile = new File(String.valueOf(toDir.getAbsolutePath()) + System.getProperty("file.separator") + newname);
        return tmpfromDir.renameTo(toFile);
    }

    public static void clearTableModel(TableModel model) {
        TableModelListener[] listeners = ((AbstractTableModel)model).getTableModelListeners();
        int i = 0;
        while (i < listeners.length) {
            model.removeTableModelListener(listeners[i]);
            ++i;
        }
        int row = model.getRowCount();
        int column = model.getColumnCount();
        logger.debug((Object)("clearing row, column: " + row + " " + column));
        int i2 = 0;
        while (i2 < row) {
            int j = 0;
            while (j < column) {
                model.setValueAt("", i2, j);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < listeners.length) {
            model.addTableModelListener(listeners[i2]);
            ++i2;
        }
    }

    public static void bootPropertyPanel() {
        PropertyPanel pp = new PropertyPanel();
    }

    public static double getNorm(double[] v) {
        double norm = 0.0;
        if (v != null) {
            int i = 0;
            while (i < v.length) {
                norm += v[i] * v[i];
                ++i;
            }
        }
        return Math.sqrt(norm);
    }

    public static void normalize(double[] v) {
        double norm = Utils.getNorm(v);
        int i = 0;
        while (i < v.length) {
            v[i] = v[i] / norm;
            ++i;
        }
    }

    public static int getNumLines(String fname) {
        int sum = 0;
        BufferedReader br = null;
        try {
            try {
                FileReader freader = new FileReader(fname);
                br = new BufferedReader(freader);
                while (br.readLine() != null) {
                    ++sum;
                }
                br.close();
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return -1;
                }
                return -1;
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
                return -1;
            }
        }
        return sum;
    }

    public static void main(String[] args) {
        System.out.println("original path: " + args[0]);
        System.out.println("parsed path: " + Utils.getPath(args[0]));
    }

    public static File getTmpFile() {
        String now = String.valueOf(Calendar.getInstance().getTimeInMillis());
        String tmpDir = System.getProperty("java.io.tmpdir");
        String tmpFile = String.valueOf(tmpDir) + System.getProperty("file.separator") + "tmp" + now;
        return new File(tmpFile);
    }

    public static String escapeBackSlash(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        Character bs = new Character('\\');
        char[] array = path.toCharArray();
        String ret = "";
        int i = 0;
        while (i < array.length) {
            ret = String.valueOf(ret) + String.valueOf(array[i]);
            if (array[i] == '\\') {
                ret = String.valueOf(ret) + "\\";
            }
            ++i;
        }
        return ret;
    }

    public static Vector removeDupli(Object[] arg) {
        if (arg == null) {
            return null;
        }
        Arrays.sort(arg);
        Vector<Object> vec = new Vector<Object>();
        int i = 0;
        while (i < arg.length) {
            if (vec.indexOf(arg[i]) < 0) {
                vec.addElement(arg[i]);
            }
            ++i;
        }
        return vec;
    }

    public static Vector removeDupli(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Object[] objs = new Object[vector.size()];
        vector.copyInto(objs);
        return Utils.removeDupli(objs);
    }

    public static String getStringFromFile(String file) {
        Vector<Byte> vec;
        String ret;
        block20: {
            ret = "";
            InputStream in = null;
            vec = new Vector<Byte>();
            try {
                int b;
                in = new BufferedInputStream(new FileInputStream(file));
                while ((b = in.read()) != -1) {
                    vec.addElement(new Byte((byte)b));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block20;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                break block20;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[] by = new byte[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            by[i] = (Byte)vec.get(i);
            ++i;
        }
        ret = new String(by);
        return ret;
    }

    public static Properties getPropertiesFrom(String path) {
        Properties properties = new Properties();
        InputStream inp = null;
        try {
            try {
                inp = Utils.class.getResourceAsStream(path);
                properties.load(inp);
            }
            catch (IOException ioe) {
                logger.error((Object)"failed to load property file...");
                try {
                    if (inp != null) {
                        inp.close();
                    }
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
                return null;
            }
        }
        finally {
            try {
                if (inp != null) {
                    inp.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return properties;
    }

    public static String getRelativePath(String pathFrom, String pathTo, boolean forwardSlash) {
        if (pathFrom == null || pathTo == null) {
            return null;
        }
        String FS = System.getProperty("file.separator");
        if (forwardSlash) {
            FS = "/";
        }
        if (new File(pathFrom).equals(new File(pathTo))) {
            return "." + FS;
        }
        String pathFrom_ = pathFrom.trim();
        String pathTo_ = pathTo.trim();
        String filesep = "/";
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            pathFrom_ = pathFrom_.toLowerCase();
            pathTo_ = pathTo_.toLowerCase();
            filesep = "\\\\";
        }
        String[] arfrom = pathFrom_.split(filesep);
        String[] arto = pathTo_.split(filesep);
        if (arfrom.length == 0 || arto.length == 0) {
            return null;
        }
        int leng = arfrom.length;
        if (leng > arto.length) {
            leng = arto.length;
        }
        int commonIndex = leng;
        int i = 0;
        while (i < leng) {
            if (!arfrom[i].equals(arto[i])) {
                commonIndex = i;
                break;
            }
            ++i;
        }
        String commonPrefix = arfrom[0];
        int i2 = 1;
        while (i2 < commonIndex) {
            commonPrefix = String.valueOf(commonPrefix) + FS + arfrom[i2];
            ++i2;
        }
        logger.debug((Object)("common prefix: " + commonPrefix));
        String suffix = "";
        if (commonPrefix.length() < pathTo.length()) {
            suffix = pathTo.substring(commonPrefix.length() + 1, pathTo.length()).trim();
        }
        String prefix = "";
        if (commonPrefix.length() < pathFrom.length()) {
            String tmp = pathFrom.substring(commonPrefix.length() + 1, pathFrom.length()).trim();
            logger.debug((Object)("pathfrom - common: " + tmp));
            String[] array = tmp.split(filesep);
            if (array != null && array.length != 0) {
                int i3 = 0;
                while (i3 < array.length) {
                    if (array[i3].trim().length() != 0) {
                        prefix = String.valueOf(prefix) + ".." + FS;
                    }
                    ++i3;
                }
            }
        }
        return String.valueOf(prefix) + suffix;
    }

    public static String getRelativePath(String pathFrom, String pathTo) {
        return Utils.getRelativePath(pathFrom, pathTo, false);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isCreatable(File parentDir, String fname) {
        if (fname == null || fname.trim().length() == 0) {
            return false;
        }
        File[] files = parentDir.listFiles();
        if (files.length == 0) {
            return true;
        }
        File testFile = new File(parentDir, fname.trim());
        int i = 0;
        while (i < files.length) {
            if (files[i].equals(testFile)) {
                return false;
            }
            ++i;
        }
        boolean btest = testFile.mkdir();
        if (!btest) {
            return false;
        }
        testFile.delete();
        return true;
    }

    public static int parseJREVersion() {
        String ver = System.getProperty("java.version");
        String vers = ver.substring(0, 5);
        String[] verss = vers.split("\\.");
        String str = "";
        int i = 0;
        while (i < verss.length) {
            str = String.valueOf(str) + verss[i];
            ++i;
        }
        return Integer.parseInt(str);
    }
}

