/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.ssh.SessionCreator;
import ciss.phase_viewer.ssh.SshClient;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class PathSelector
extends JPanel {
    private static Logger logger = Logger.getLogger((String)PathSelector.class.getName());
    public static final int FILE = 0;
    public static final int DIRECTORY_ONLY = 1;
    public static final int FILE_PROJ_BROWSER = 0;
    public static final int DIRECTORY_ONLY_PROJ_BROWSER = 1;
    private int mode = 1;
    private String title;
    private int width = 20;
    private JTextField textfield;
    private HostInfo hostinfo;
    private boolean isRemote = false;
    private SshClient sshclient;
    private JButton button;

    public PathSelector(String title) {
        this.title = title;
        this.init();
    }

    public PathSelector(String title, int width) {
        this.title = title;
        this.width = width;
        this.init();
    }

    public PathSelector(String title, int width, int mode) {
        this.title = title;
        this.width = width;
        this.mode = mode;
        this.init();
    }

    public PathSelector(String title, JTextField textfield) {
        this.title = title;
        this.textfield = textfield;
        this.init();
    }

    public PathSelector(String title, int width, JTextField textfield) {
        this.title = title;
        this.width = width;
        this.textfield = textfield;
        this.init();
    }

    public PathSelector(String title, int width, int mode, JTextField textfield) {
        this.title = title;
        this.width = width;
        this.mode = mode;
        this.textfield = textfield;
        this.init();
    }

    public PathSelector(String title, boolean isRemote) {
        this.title = title;
        this.isRemote = isRemote;
        this.init();
    }

    public PathSelector(String title, int width, boolean isRemote) {
        this.title = title;
        this.width = width;
        this.isRemote = isRemote;
        this.init();
    }

    public PathSelector(String title, int width, int mode, boolean isRemote) {
        this.title = title;
        this.width = width;
        this.mode = mode;
        this.isRemote = isRemote;
        this.init();
    }

    public PathSelector(String title, JTextField textfield, boolean isRemote) {
        this.title = title;
        this.textfield = textfield;
        this.isRemote = isRemote;
        this.init();
    }

    public PathSelector(String title, int width, JTextField textfield, boolean isRemote) {
        this.title = title;
        this.width = width;
        this.textfield = textfield;
        this.isRemote = isRemote;
        this.init();
    }

    public PathSelector(String title, int width, JTextField textfield, boolean isRemote, int mode) {
        this.title = title;
        this.width = width;
        this.textfield = textfield;
        this.isRemote = isRemote;
        this.mode = mode;
        this.init();
    }

    public PathSelector(String title, int width, int mode, JTextField textfield, boolean isRemote) {
        this.title = title;
        this.width = width;
        this.mode = mode;
        this.textfield = textfield;
        this.isRemote = isRemote;
        this.init();
    }

    private void init() {
        this.setBorder(new TitledBorder(this.title));
        this.setLayout(new BoxLayout(this, 0));
        if (this.textfield == null) {
            this.textfield = new JTextField(this.width);
        }
        this.add(this.textfield);
        this.button = new JButton("choose...");
        this.add(this.button);
        int x = this.button.getSize().width;
        int y = this.button.getSize().height;
        this.textfield.setPreferredSize(new Dimension(x, y));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelector.this.bootFileChooser();
            }
        });
    }

    public String getPath() {
        return Utils.getPathDQ(this.textfield.getText());
    }

    public String getRawPath() {
        return this.textfield.getText().trim();
    }

    public void setPath(String path) {
        this.textfield.setText(path);
    }

    public void setHostInfo(boolean isRemote) {
        this.isRemote = isRemote;
    }

    public void setSshClient(SshClient sshclient_) {
        this.sshclient = sshclient_;
        ActionListener[] lis = this.button.getActionListeners();
        if (lis != null) {
            int i = 0;
            while (i < lis.length) {
                this.button.removeActionListener(lis[i]);
                ++i;
            }
        }
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelector.this.hostinfo = PathSelector.this.sshclient.getHostInfo();
                PathSelector.this.bootFileChooser();
            }
        });
    }

    private void bootFileChooser() {
        boolean proj = this.mode == 0 || this.mode == 1;
        ChaseFileChooser fdlg = new ChaseFileChooser("path", proj);
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("choose");
        fdlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (this.mode == 0) {
            fdlg.setFileSelectionMode(0);
        } else if (this.mode == 1) {
            fdlg.setFileSelectionMode(1);
        } else {
            System.out.println("wrong specification of mode");
            return;
        }
        if (fdlg.showDialog(this, "Select") != 0) {
            return;
        }
        this.textfield.setText(fdlg.getSelectedFile().getAbsolutePath());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textfield.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public JTextField getTextField() {
        return this.textfield;
    }

    public void setTextField(JTextField textfield) {
        this.textfield = textfield;
    }

    private ChannelSftp connect() {
        ChannelSftp c = null;
        if (this.hostinfo.isLocalHost()) {
            return null;
        }
        try {
            logger.debug((Object)"starting connection...");
            Session session = SessionCreator.getSession(this.hostinfo);
            Channel channel = session.openChannel("sftp");
            channel.connect();
            c = (ChannelSftp)channel;
            logger.info((Object)("sftp connection to host: " + this.hostinfo.getName()));
            logger.debug((Object)("current directory: " + c.pwd()));
        }
        catch (Exception exc) {
            logger.error((Object)"failed connection");
        }
        return c;
    }
}

