/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.io.AtomCoordsIO;
import ciss.phase_viewer.atomcoord.io.FrameCombo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

class XYZOptionsPanel
extends JPanel {
    private Logger logger = Logger.getLogger(XYZOptionsPanel.class);
    private JInternalFrame iframe;
    private JFrame jframe;
    private AtomCoordsIO io;
    static String GENERIC = "generic";
    static String XMAKEMOL = "xmakemol";
    private String[] TYPE_CHOICE = new String[]{GENERIC, XMAKEMOL};
    static String TYPE = "type";
    static String FRAME = "frame";
    static String FORCE = "force";
    private PropertyChangeListener listener;
    private JTextField forceFactor;
    private JComboBox comboType;
    private FrameCombo frameCombo;

    XYZOptionsPanel(JInternalFrame iframe, AtomCoordsIO io, PropertyChangeListener listener) {
        this.iframe = iframe;
        this.io = io;
        this.listener = listener;
        this.init();
    }

    XYZOptionsPanel(JFrame jframe, AtomCoordsIO io, PropertyChangeListener listener) {
        this.jframe = jframe;
        this.io = io;
        this.listener = listener;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JPanel ptype = new JPanel();
        ptype.setBorder(new TitledBorder("type"));
        this.comboType = new JComboBox<String>(this.TYPE_CHOICE);
        ptype.add(this.comboType);
        JPanel pforce = new JPanel();
        pforce.setBorder(new TitledBorder("force factor"));
        this.forceFactor = new JTextField(3);
        pforce.add(this.forceFactor);
        this.forceFactor.setText("1");
        this.frameCombo = new FrameCombo();
        p.add(ptype);
        p.add(pforce);
        p.add(this.frameCombo);
        this.add(p);
        JPanel btns = new JPanel();
        btns.setLayout(new BoxLayout(btns, 0));
        JButton ok = new JButton("ok");
        JButton can = new JButton("cancel");
        btns.add(ok);
        btns.add(can);
        this.add(btns);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(FORCE, XYZOptionsPanel.this.forceFactor.getText().trim());
                map.put(FRAME, XYZOptionsPanel.this.frameCombo);
                map.put(TYPE, XYZOptionsPanel.this.comboType.getSelectedItem().toString());
                XYZOptionsPanel.this.io.setOptions(map);
                if (XYZOptionsPanel.this.iframe == null) {
                    XYZOptionsPanel.this.jframe.dispose();
                } else {
                    XYZOptionsPanel.this.iframe.dispose();
                }
                XYZOptionsPanel.this.listener.propertyChange(null);
            }
        });
        can.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (XYZOptionsPanel.this.iframe == null) {
                    XYZOptionsPanel.this.jframe.dispose();
                } else {
                    XYZOptionsPanel.this.iframe.dispose();
                }
                XYZOptionsPanel.this.logger.info((Object)"operation canceled.");
            }
        });
    }
}

