/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.AtomCoordsIO;
import ciss.phase_viewer.atomcoord.io.Exportable;
import ciss.phase_viewer.atomcoord.io.Exporter;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ExportFileChooser
extends ChaseFileChooser
implements PropertyChangeListener {
    private Logger logger = Logger.getLogger((String)ExportFileChooser.class.getName());
    private Exportable caller;
    private Exporter[] exporters;
    private AtomCoords[] targetCoords;
    private Component parent;
    private String atomCoordsFile;

    public ExportFileChooser(Exportable caller, Component parent) {
        super("atom", true);
        this.caller = caller;
        this.parent = parent;
        this.targetCoords = caller.getCoordsToExport();
        this.setDialogType(2);
        this.setDialogTitle("select atomic configuration file");
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
        this.init();
    }

    private void init() {
        this.createExporters();
        int i = 0;
        while (i < this.exporters.length) {
            this.addChoosableFileFilter(this.exporters[i].getFileFilter());
            ++i;
        }
        this.setFileFilter(this.getChoosableFileFilters()[0]);
        if (this.showOpenDialog(this.parent) != 0) {
            return;
        }
        this.atomCoordsFile = this.getSelectedFile().getAbsolutePath();
        int index = this.getSelectedFileFilterIndex();
        if (!this.exporters[index].hasOptions()) {
            this.exporters[index].writeAtomCoordsTo(this.targetCoords, this.atomCoordsFile);
            this.caller.coordsExported(this.targetCoords, this.exporters[index].getType(), this.atomCoordsFile);
        } else {
            this.exporters[index].createOptionsPanel(false, this, this.atomCoordsFile);
        }
    }

    private void createExporters() {
        Document doc = XMLUtils.getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
        Element root = doc.getRootElement();
        List list = root.getChildren("exporter");
        Vector<String> vec = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            String loadClass = ((Element)list.get(i)).getChildTextTrim("loadclass");
            vec.addElement(loadClass);
            ++i;
        }
        this.exporters = new Exporter[vec.size()];
        i = 0;
        while (i < vec.size()) {
            String load = (String)vec.get(i);
            this.exporters[i] = (Exporter)PluginLoader.instantiate(load, null);
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int index = this.getSelectedFileFilterIndex();
        this.exporters[index].writeAtomCoordsTo(this.targetCoords, this.atomCoordsFile);
        this.caller.coordsExported(this.targetCoords, this.exporters[index].getType(), this.atomCoordsFile);
    }
}

