/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.atomcoord.pmodel.Cif;
import ciss.phase_viewer.atomcoord.pmodel.Pmodel;
import ciss.phase_viewer.atomcoord.pmodel.PmodelException;
import ciss.phase_viewer.atomcoord.pmodel.SpaceGroup;
import ciss.phase_viewer.mainpanel.Desk;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CIFImporter
implements Importer {
    private Logger logger = Logger.getLogger((String)CIFImporter.class.getName());
    private int selectedData = 1;
    private int selectedChoice = 0;

    private String[] getCIFBlockTitles(String cifFile) {
        try {
            return Cif.getDataBlockTitle(cifFile);
        }
        catch (PmodelException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @Override
    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        this.logger.info((Object)("parsing cif file... " + fileName));
        Pmodel pmodel = new Pmodel();
        try {
            pmodel.readCIF(fileName, this.selectedData);
        }
        catch (PmodelException e1) {
            e1.printStackTrace();
            this.logger.error((Object)("failed to read CIF : " + fileName));
            return null;
        }
        if (pmodel.getNumSymmetryEquivPosInCif() > 1) {
            try {
                pmodel.makeSpaceGroup();
            }
            catch (PmodelException e) {
                this.logger.error((Object)("failed to generate space group from CIF : " + fileName));
                return null;
            }
        } else if (pmodel.getIntTablesNum() > 0) {
            try {
                pmodel.makeSpaceGroup(this.selectedChoice);
            }
            catch (PmodelException e) {
                this.logger.error((Object)("failed to generate space group from CIF : " + fileName));
                return null;
            }
        } else {
            this.logger.error((Object)"cannot detect symmetry informations");
            return null;
        }
        try {
            pmodel.makeLattice();
        }
        catch (PmodelException e) {
            e.printStackTrace();
            this.logger.error((Object)("failed to generate lattice from CIF : " + fileName));
            return null;
        }
        String[] symbols = pmodel.getSymbol();
        boolean hasNumbers = false;
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i].matches(".*\\d+.*")) {
                hasNumbers = true;
                break;
            }
            ++i;
        }
        boolean strip = false;
        if (hasNumbers) {
            strip = JOptionPane.showInternalConfirmDialog(Desk.getDesktop().getSelectedFrame(), "strip numbers from symbol?", "strip numbers", 0, 3) == 0;
        }
        AtomCoords coords = new AtomCoords();
        coords.isCart(true);
        coords.setUnit(2);
        AtomList list = coords.getAtomList();
        double[][] cellVec = pmodel.getCellVec();
        double[] av = new double[3];
        double[] bv = new double[3];
        double[] cv = new double[3];
        int i2 = 0;
        while (i2 < 3) {
            av[i2] = cellVec[0][i2];
            bv[i2] = cellVec[1][i2];
            cv[i2] = cellVec[2][i2];
            ++i2;
        }
        Cell cellv = new Cell(av, bv, cv);
        coords.setCell(cellv);
        int NumAt = pmodel.getNumberOfAtoms();
        double[][] fposs = pmodel.getInternalPosition();
        int i3 = 0;
        while (i3 < fposs.length) {
            this.logger.debug((Object)("fractional pos " + i3 + " " + fposs[i3][0] + ", " + fposs[i3][1] + ", " + fposs[i3][2]));
            ++i3;
        }
        i3 = 0;
        while (i3 < NumAt) {
            String element = symbols[i3];
            if (strip) {
                element = element.split("\\d+")[0].split("\\(")[0];
            }
            this.logger.debug((Object)("atom :" + i3 + " name: " + element));
            double[] cpos = new double[3];
            int j = 0;
            while (j < 3) {
                cpos[j] = 0.0;
                int k = 0;
                while (k < 3) {
                    cpos[j] = cpos[j] + cellVec[k][j] * fposs[i3][k];
                    ++k;
                }
                ++j;
            }
            Atom at = new Atom(element, cpos);
            list.addAtom(at);
            ++i3;
        }
        this.logger.debug((Object)list);
        return new AtomCoords[]{coords};
    }

    @Override
    public String getType() {
        return "CIF";
    }

    @Override
    public FileFilter getFileFilter() {
        return new CIFFileFilter();
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public void createOptionsPanel(boolean isheavy, PropertyChangeListener listener, String fileName) {
        int maxChoice;
        Object[] titles = this.getCIFBlockTitles(fileName);
        if (titles == null || titles.length == 0) {
            this.selectedData = 0;
        } else if (titles.length == 1) {
            this.selectedData = 1;
        } else {
            Object ret = JOptionPane.showInternalInputDialog(Desk.getDesktop().getSelectedFrame(), "select data", "select data", 1, null, titles, titles[0]);
            if (ret != null) {
                int i = 0;
                while (i < titles.length) {
                    if (titles[i] == ret) {
                        this.selectedData = i + 1;
                    }
                    ++i;
                }
            }
        }
        Pmodel pmodel = new Pmodel();
        try {
            pmodel.readCIF(fileName, this.selectedData);
        }
        catch (PmodelException e1) {
            e1.printStackTrace();
            listener.propertyChange(null);
            return;
        }
        if (pmodel.getNumSymmetryEquivPosInCif() <= 1 && pmodel.getIntTablesNum() > 0 && (maxChoice = SpaceGroup.getMaxChoice(pmodel.getIntTablesNum())) > 1) {
            Object[] choices = new Integer[maxChoice];
            int i = 0;
            while (i < maxChoice) {
                choices[i] = new Integer(i);
                ++i;
            }
            Object ret = JOptionPane.showInternalInputDialog(Desk.getDesktop().getSelectedFrame(), "select choice", "select choice", 1, null, choices, choices[0]);
            if (ret != null) {
                this.selectedChoice = (Integer)ret;
            }
        }
        listener.propertyChange(null);
    }

    @Override
    public void setOptions(HashMap options) {
    }

    @Override
    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return this.getFileFilter().accept(new File(fileName));
    }

    class CIFFileFilter
    extends FileFilter {
        CIFFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String fileName = f.getName().toLowerCase();
            if (fileName != null) {
                return fileName.endsWith(".cif");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Crystallographic Information File (*.cif)";
        }
    }
}

