/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.AtomState;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AtomStateList {
    private Logger logger = Logger.getLogger((String)AtomStateList.class.getName());
    private Vector stateVector;
    private int origNumAt;

    public AtomStateList(int numAt) {
        this.origNumAt = numAt;
        this.stateVector = new Vector();
        int i = 0;
        while (i < numAt) {
            this.stateVector.addElement(new AtomState(AtomState.UNCHANGED, i));
            ++i;
        }
    }

    public AtomStateList(int[] indeces) {
        this.origNumAt = indeces.length;
        this.stateVector = new Vector();
        int i = 0;
        while (i < this.origNumAt) {
            this.stateVector.addElement(new AtomState(AtomState.UNCHANGED, indeces[i]));
            ++i;
        }
    }

    private int getNumAdded() {
        int ret = 0;
        int i = 0;
        while (i < this.stateVector.size()) {
            AtomState as = (AtomState)this.stateVector.get(i);
            if (as.mode == AtomState.ADDED) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public int[] getIndexMap() {
        int added = this.getNumAdded();
        int[] ret = new int[this.origNumAt + added];
        int i = 0;
        while (i < this.stateVector.size()) {
            AtomState as = (AtomState)this.stateVector.get(i);
            ret[as.origIndex] = as.mode != AtomState.REMOVED ? as.index : -1;
            ++i;
        }
        return ret;
    }

    public void atomAdded() {
        this.logger.debug((Object)"atom added");
        int natNow = this.getNumAt();
        this.stateVector.addElement(new AtomState(AtomState.ADDED, natNow));
    }

    public void atomAdded(int index) {
        this.logger.debug((Object)("atom added at " + index));
        int i = 0;
        while (i < this.stateVector.size()) {
            AtomState as = (AtomState)this.stateVector.get(i);
            if (as.index >= index) {
                ++as.index;
            }
            ++i;
        }
        this.stateVector.add(new AtomState(AtomState.ADDED, index));
    }

    public void atomRemoved(int removed) {
        if (removed < 0 || removed >= this.stateVector.size()) {
            return;
        }
        int i = 0;
        while (i < this.stateVector.size()) {
            AtomState as = (AtomState)this.stateVector.get(i);
            if (as.index > removed) {
                --as.index;
            }
            ++i;
        }
        this.stateVector.set(removed, new AtomState(AtomState.REMOVED, removed));
    }

    public void atomModified(int mod) {
        if (mod < 0 || mod >= this.stateVector.size()) {
            return;
        }
        this.stateVector.set(mod, new AtomState(AtomState.MODIFIED, mod));
    }

    public int getNumAt() {
        int ret = 0;
        int i = 0;
        while (i < this.stateVector.size()) {
            if (((AtomState)this.stateVector.get((int)i)).mode != AtomState.REMOVED) {
                ++ret;
            }
            ++i;
        }
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }

    public AtomState[] getResults() {
        Object[] res = new AtomState[this.stateVector.size()];
        this.stateVector.copyInto(res);
        Arrays.sort(res);
        return res;
    }

    public int getOrigNumAt() {
        return this.origNumAt;
    }
}

