/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.MultipleAtomEditor;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.ACVAtomEditor;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.Atom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomFilledCircle;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomSelectionCanvas;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomSphere;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import org.apache.log4j.Logger;

public class AtomPicker
extends PickMouseBehavior {
    private static Logger logger = Logger.getLogger((String)AtomPicker.class.getName());
    private Atom atom;
    private AtomObject atomObject;
    private WakeupCriterion[] mouseEvents;
    private WakeupOr mouseCriterion;
    private PickTool picker;
    int pickMode = 256;
    private Canvas3D canvas;
    private TransformGroup parent;
    private boolean button1Press = false;

    public AtomPicker(Canvas3D canvas, BranchGroup root, Bounds bounds, Atom atom) {
        super(canvas, root, bounds);
        this.atom = atom;
        this.atomObject = atom.getAtomObject();
        this.setSchedulingBounds(bounds);
        this.pickCanvas.setMode(this.pickMode);
        this.canvas = canvas;
    }

    public AtomPicker(Canvas3D canvas, BranchGroup root, Bounds bounds) {
        super(canvas, root, bounds);
        this.setSchedulingBounds(bounds);
        this.pickCanvas.setMode(this.pickMode);
        this.canvas = canvas;
    }

    public void processStimulus(Enumeration criteria) {
        AWTEvent[] evt = null;
        int xpos = 0;
        int ypos = 0;
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt == null) {
            return;
        }
        if (evt[0] instanceof MouseEvent) {
            this.mevent = (MouseEvent)evt[0];
            this.processMouseEvent((MouseEvent)evt[0]);
            xpos = this.mevent.getPoint().x;
            ypos = this.mevent.getPoint().y;
        }
        if (this.buttonPress && !this.update(xpos, ypos)) {
            ((AtomSelectionCanvas)this.parent).deselectAll();
        }
        if (this.button1Press) {
            this.bootAtomAtributeEditPanel(xpos, ypos);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent evt) {
        this.buttonPress = false;
        this.button1Press = false;
        if (evt.getButton() == 2 || evt.getButton() == 1 && evt.isAltDown()) {
            if (evt.getID() == 501 || evt.getID() == 500) {
                this.buttonPress = true;
                return;
            }
            if (evt.getID() == 503) {
                this.buttonPress = true;
                return;
            }
        } else if (evt.getButton() == 1 && !evt.isAltDown()) {
            this.button1Press = true;
            return;
        }
    }

    public void updateScene(int xpos, int ypos) {
    }

    private boolean update(int xpos, int ypos) {
        if (this.pickCanvas == null) {
            return false;
        }
        this.pickCanvas.setShapeLocation(xpos, ypos);
        if (this.pickCanvas == null) {
            return false;
        }
        PickResult[] result = this.pickCanvas.pickAllSorted();
        if (result == null) {
            logger.debug((Object)"AtomPicker returned null.");
            return false;
        }
        int i = 0;
        while (i < result.length) {
            Primitive pri = (Primitive)result[i].getNode(4);
            if (pri != null && pri instanceof AtomSphere) {
                AtomObject obj = ((AtomSphere)pri).getAtomObject();
                boolean b = obj.toggleSelected();
                if (b) {
                    logger.info((Object)("selected atom " + obj.getID()));
                } else {
                    logger.info((Object)("deselected atom " + obj.getID()));
                }
                logger.debug((Object)obj);
                return true;
            }
            Shape3D s3d = (Shape3D)result[i].getNode(1);
            if (s3d != null && s3d instanceof AtomFilledCircle) {
                AtomObject obj = ((AtomFilledCircle)s3d).getAtomObject();
                boolean b = obj.toggleSelected();
                if (b) {
                    logger.info((Object)("selected atom " + obj.getID()));
                } else {
                    logger.info((Object)("deselected atom " + obj.getID()));
                }
                logger.debug((Object)obj);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void bootAtomAtributeEditPanel(int xpos, int ypos) {
        if (this.pickCanvas == null) {
            return;
        }
        this.pickCanvas.setShapeLocation(xpos, ypos);
        if (this.pickCanvas == null) {
            return;
        }
        PickResult[] result = this.pickCanvas.pickAllSorted();
        if (result == null) {
            logger.debug((Object)"AtomPicker returned null.");
            return;
        }
        int numSelected = ((TGAtom)this.parent).getSelectedAtomCount();
        int i = 0;
        while (i < result.length) {
            AtomObject obj;
            Shape3D s3d;
            AtomObject obj2;
            Primitive pri = (Primitive)result[i].getNode(4);
            if (pri != null && pri instanceof AtomSphere && (obj2 = ((AtomSphere)pri).getAtomObject()).isSelected()) {
                if (numSelected == 1) {
                    logger.debug((Object)"booting atom atribute edit panel ...");
                    this.bootAtomEditor(Integer.parseInt(obj2.getID()));
                } else if (numSelected > 1) {
                    MultipleAtomEditor edit = new MultipleAtomEditor(((TGAtom)this.parent).getParentFrame());
                    ((TGAtom)this.parent).getParentFrame().addDisposeOnExit(edit);
                    return;
                }
            }
            if ((s3d = (Shape3D)result[i].getNode(1)) != null && s3d instanceof AtomFilledCircle && (obj = ((AtomFilledCircle)s3d).getAtomObject()).isSelected()) {
                if (numSelected == 1) {
                    logger.debug((Object)"booting atom atribute edit panel ...");
                    this.bootAtomEditor(Integer.parseInt(obj.getID()));
                } else if (numSelected > 1) {
                    MultipleAtomEditor edit = new MultipleAtomEditor(((TGAtom)this.parent).getParentFrame());
                    ((TGAtom)this.parent).getParentFrame().addDisposeOnExit(edit);
                    return;
                }
            }
            ++i;
        }
    }

    private void bootAtomEditor(int id) {
        TGAtom tgatom = (TGAtom)this.parent;
        MainPanel mp = tgatom.getParentFrame();
        ciss.phase_viewer.atomcoord.Atom atom = mp.getCD().getAtomCoords().getAtomList().getAtomAt(id - 1);
        logger.debug((Object)atom);
        ACVAtomEditor editor = new ACVAtomEditor(mp.getData().getTableColums(), atom, false, id - 1, "edit attributes for atom no. " + new Integer(id), new Dimension(400, 250), 3, mp);
        editor.addAtomListener(((TGAtom)mp.getRootTransform()).getBasicOperations());
        mp.addDisposeOnExit(editor);
        editor.revalidate();
    }

    public void setParent(TransformGroup parent) {
        this.parent = parent;
    }
}

