/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.ACVMultipleAtomEditor;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

class ACVMultipleAtomEditorPanel
extends JPanel {
    private Logger logger = Logger.getLogger((String)ACVMultipleAtomEditorPanel.class.getName());
    private ACVMultipleAtomEditor parent;
    public JButton applyButton;
    public JButton closeButton;
    public JButton deleteButton;
    public JTextField editX;
    public JTextField editY;
    public JTextField editZ;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JPanel jPanel4;
    public JPanel jPanel5;
    public JPanel jPanel6;
    public JTextField jTextField5;

    protected ACVMultipleAtomEditorPanel(ACVMultipleAtomEditor parent) {
        this.parent = parent;
        this.initAttrEditors();
        this.initComponents();
    }

    private void initAttrEditors() {
        InputInterfaceTableColumns[] columns = this.parent.getParentFrame().getData().getTableColums();
        if (columns == null && columns.length == 0) {
            this.logger.error((Object)"invalid TableSpec file.");
            return;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        int editor_per_row = 4;
        int editor_count = 0;
        JPanel prow = null;
        int i = 0;
        while (i < columns.length) {
            if (columns[i].hasApplytoAll()) {
                if (editor_count % editor_per_row == 0) {
                    prow = new JPanel();
                    prow.setLayout(new GridLayout(1, editor_per_row));
                    this.logger.info((Object)"adding prow");
                    p.add(prow);
                    editor_count = 0;
                }
                JPanel pedi2 = new JPanel();
                pedi2.setBorder(new TitledBorder(columns[i].getName()));
                if (columns[i].getCellEditor() == InputInterfaceTableColumns.TEXT_FIELD) {
                    JTextField text = new JTextField(5);
                    pedi2.add(text);
                } else if (columns[i].getCellEditor() == InputInterfaceTableColumns.CHECK_BOX) {
                    JCheckBox check = new JCheckBox(columns[i].getName());
                    pedi2.add(check);
                } else if (columns[i].getCellEditor() == InputInterfaceTableColumns.COMBO_BOX) {
                    JComboBox<String> box = new JComboBox<String>(columns[i].getChoices());
                    pedi2.add(box);
                }
                prow.add(pedi2);
                ++editor_count;
            }
            ++i;
        }
        this.add(p);
        this.revalidate();
    }

    private void initComponents() {
        this.jTextField5 = new JTextField();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.editY = new JTextField();
        this.jPanel5 = new JPanel();
        this.editZ = new JTextField();
        this.jPanel6 = new JPanel();
        this.editX = new JTextField();
        this.jPanel2 = new JPanel();
        this.closeButton = new JButton();
        this.applyButton = new JButton();
        this.deleteButton = new JButton();
        this.jTextField5.setText("0.0");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Translation", 0, 0, new Font("MS UI Gothic", 0, 12), new Color(0, 51, 102)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "y", 0, 0, new Font("MS UI Gothic", 2, 12)));
        this.editY.setText("0.0");
        this.editY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.editYActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.editY, -1, 100, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.editY, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "z", 0, 0, new Font("MS UI Gothic", 2, 12)));
        this.editZ.setText("0.0");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.editZ, -1, 100, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.editZ, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "x", 0, 0, new Font("MS UI Gothic", 2, 12)));
        this.editX.setText("0.0");
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((Component)this.editX, -1, 100, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel6Layout.createSequentialGroup().add((Component)this.editX, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel6, -2, -1, -2).add(20, 20, 20).add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0, 17, Short.MAX_VALUE).add((Component)this.jPanel5, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add(1, (Component)this.jPanel5).add(1, (Component)this.jPanel4).add((Component)this.jPanel6)).addContainerGap()));
        this.closeButton.setText("close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.closeButtonActionPerformed(evt);
            }
        });
        this.applyButton.setText("apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.applyButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("delete selected atoms");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.applyButton).addPreferredGap(0).add((Component)this.deleteButton).addPreferredGap(0).add((Component)this.closeButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.closeButton).add(1, (GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.applyButton).add((Component)this.deleteButton))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(69, 69, 69).add((Component)this.jPanel2, -2, -1, -2))).addContainerGap(24, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, 81, -2).addPreferredGap(0, 14, Short.MAX_VALUE).add((Component)this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteAll();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.doTranslation();
        this.parent.getParentFrame().getCD().update();
        this.revalidate();
    }

    private void deleteAll() {
        CoordsViewerInterface parentFrame = this.parent.getParentFrame();
        TGAtom tgatom = (TGAtom)parentFrame.getScene().getTGAtom();
        AtomObject[] atoms = tgatom.getSelectedAtoms();
        if (atoms == null || atoms.length == 0) {
            return;
        }
        AtomCoords coords = this.parent.getParentFrame().getCD().getAtomCoords();
        Vector<Integer> indexVector = new Vector<Integer>();
        int i = 0;
        while (i < atoms.length) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            indexVector.addElement(new Integer(id));
            ++i;
        }
        if (indexVector.size() == 0) {
            return;
        }
        Object[] indeces = new Integer[indexVector.size()];
        indexVector.copyInto(indeces);
        Arrays.sort(indeces);
        int i2 = indeces.length - 1;
        while (i2 >= 0) {
            coords.getAtomList().removeAtomAt((Integer)indeces[i2]);
            --i2;
        }
        coords.getAtomList().setUndoCount(atoms.length);
        this.parent.getParentFrame().getCD().setCoords(coords);
        tgatom.deselectAll();
        this.parent.dispose();
    }

    private void doTranslation() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(this.editX.getText());
            y = Double.parseDouble(this.editY.getText());
            z = Double.parseDouble(this.editZ.getText());
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)"enter double values.");
            return;
        }
        catch (NullPointerException npe) {
            this.logger.error((Object)"found invalid value at 'translation'");
            return;
        }
        CoordsViewerInterface parentFrame = this.parent.getParentFrame();
        TGAtom tgatom = (TGAtom)parentFrame.getScene().getTGAtom();
        AtomObject[] atoms = tgatom.getSelectedAtoms();
        if (atoms == null || atoms.length == 0) {
            return;
        }
        AtomCoords coords = this.parent.getParentFrame().getCD().getAtomCoords();
        int i = 0;
        while (i < atoms.length) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            double[] pos = this.parent.getParentFrame().getCD().getPos(id);
            pos[0] = pos[0] + x;
            pos[1] = pos[1] + y;
            pos[2] = pos[2] + z;
            Atom atnow = coords.getAtomList().getAtomAt(id);
            coords.getAtomList().replaceAtomAt(id, new Atom(atnow.getElementName(), pos, atnow.getAuxil()));
            ++i;
        }
        coords.getAtomList().setUndoCount(atoms.length);
        this.parent.getParentFrame().getCD().setCoordsNoUpdate(coords);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.parent.dispose();
    }

    private void editYActionPerformed(ActionEvent evt) {
    }
}

