/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.measure.MeasureBranchGroup;
import ciss.phase_viewer.acviewer.measure.MeasureListener;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseRotate;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseTranslate;
import ciss.phase_viewer.acviewer.operations.BasicOperations;
import ciss.phase_viewer.acviewer.scenegraphelements.CellObject;
import ciss.phase_viewer.acviewer.scenegraphelements.DynamicallyEditable;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementBG;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObjectBG;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomPicker;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomSelectionCanvas;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondCalculator;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondInfo;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondObject;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomState;
import ciss.phase_viewer.atomcoord.AtomStateList;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.common.VectorOperations;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class TGAtom
extends ChaseTransformGroup
implements AtomSelectionCanvas,
Measurable,
ConfigData {
    private static Logger logger = Logger.getLogger((String)TGAtom.class.getName());
    private SceneGraphElementCreator creator;
    private MainPanel mp;
    private double lenmax;
    private double[] jusin;
    private Measure measure;
    private boolean measureAtWork = false;
    private Stack selectedAtoms = new Stack();
    private ConfigDataManager mCD;
    private J3DDataManager mACVD;
    private double[][] Dpos;
    private double[][] Dforce;
    private int NumAt;
    private double[][] cellvec;
    private BondCalculator clcbnd;
    private BondCalculator hbondCalculator;
    private boolean rescaleOnUpdate = true;
    private Transform3D buffer = new Transform3D();
    private Vector measures;
    private Vector measureListeners;
    private GlobalProperties props = PropertiesManager.getGlobalProperties(1);
    public static int ANIM = 0;
    public static int GENERIC = 1;
    private int updateMode = GENERIC;
    private BranchGroup atomBranchGroup;
    private TransformGroup atomTransformGroup;
    private Vector3d zero;
    private Vector3d atomOffset = this.zero = new Vector3d(0.0, 0.0, 0.0);
    private Vector atomSelectionCanvas;
    private BasicOperations basicOperations;
    private Vector3d offset;
    private double[] cellOffset = new double[]{0.0, 0.0, 0.0};
    private String[] elements;
    private TaggedString[][] auxils;
    private Vector bonds;
    private Vector Hbonds;
    private SceneGraphElementBG cellObject;

    public void setParentFrame(MainPanel mp) {
        this.mp = mp;
    }

    public BasicOperations getBasicOperations() {
        if (this.basicOperations == null) {
            this.basicOperations = new BasicOperations(this.mp);
        }
        return this.basicOperations;
    }

    public MainPanel getParentFrame() {
        return this.mp;
    }

    public void setPicker(AtomPicker picker) {
        picker.setParent(this);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)picker);
        this.addChild((Node)bg);
    }

    public void addAtomSelectionCanvas(AtomSelectionCanvas foo) {
        if (this.atomSelectionCanvas == null) {
            this.atomSelectionCanvas = new Vector();
        }
        this.atomSelectionCanvas.addElement(foo);
    }

    public void removeAtomSelectionCanvas(AtomSelectionCanvas foo) {
        if (this.atomSelectionCanvas == null) {
            return;
        }
        this.atomSelectionCanvas.remove(foo);
    }

    public void setUpdateMode(int updateMode) {
        this.updateMode = updateMode;
    }

    @Override
    public void addMeasureListener(MeasureListener list) {
        if (this.measureListeners == null) {
            this.measureListeners = new Vector();
        }
        this.measureListeners.addElement(list);
    }

    @Override
    public void removeMeasureListener(MeasureListener list) {
        if (this.measureListeners == null) {
            return;
        }
        this.measureListeners.remove(list);
    }

    public void setAtomOffset(Vector3d off) {
        if (Math.abs(off.x) > 0.5 || Math.abs(off.y) > 0.5 || Math.abs(off.z) > 0.5) {
            return;
        }
        this.atomOffset = off;
    }

    public void setOffset(Vector3d offset) {
        this.offset = offset;
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public double[] getJusin() {
        double[] jusin_buff = this.getConfigData().getCellOriginVector();
        double[] celloff = this.getCellOffset();
        int i = 0;
        while (i < 3) {
            jusin_buff[i] = -(jusin_buff[i] + celloff[i] * this.lenmax);
            ++i;
        }
        return jusin_buff;
    }

    public Vector3d getAtomOffset() {
        return this.atomOffset;
    }

    @Override
    public float[][] getEffectiveBounds() {
        double[][] ce = this.mCD.getCell();
        double len = this.mCD.getLenMax();
        logger.debug((Object)("lenmax: " + len));
        if (ce == null) {
            return null;
        }
        float[][] ret = new float[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                ret[i][j] = (float)(ce[i][j] / len);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public float[][] getEffectiveBounds2() {
        double[][] ce = this.mCD.getCell();
        double len = this.mCD.getLenMax();
        logger.debug((Object)("lenmax: " + len));
        if (ce == null) {
            return null;
        }
        float[][] ret = new float[3][2];
        float[] min = new float[3];
        float[] max = new float[3];
        int i = 0;
        while (i < 3) {
            min[i] = 1.0E11f;
            max[i] = -1.0E11f;
            ++i;
        }
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if ((double)min[j] > ce[i][j] / len) {
                    min[j] = (float)(ce[i][j] / len);
                }
                if ((double)max[j] < ce[i][j] / len) {
                    max[j] = (float)(ce[i][j] / len);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[i][0] = min[i];
            ret[i][1] = max[i];
            ++i;
        }
        return ret;
    }

    @Override
    public void registerMeasure(Measure measure) {
        this.registerMeasure(measure, true);
    }

    public void registerMeasure(Measure measure, boolean deselctAll) {
        if (this.measure != null && measure != null && this.measure.getClass().getName().equals(measure.getClass().getName())) {
            this.endMeasure();
        }
        this.measure = measure;
        if (this.measures == null) {
            this.measures = new Vector();
        }
        this.measures.add(measure);
        this.startMeasure(deselctAll);
    }

    @Override
    public MeasureBranchGroup[] getExistingMeasures() {
        Node[] bgroups = this.getChildren(MeasureBranchGroup.class);
        if (bgroups == null || bgroups.length == 0) {
            return null;
        }
        MeasureBranchGroup[] ret = new MeasureBranchGroup[bgroups.length];
        int i = 0;
        while (i < bgroups.length) {
            ret[i] = (MeasureBranchGroup)bgroups[i];
            ++i;
        }
        return ret;
    }

    public void toggleMeasure() {
        if (this.measureAtWork && this.measure != null) {
            this.endMeasure();
        } else {
            this.startMeasure();
        }
    }

    @Override
    public void startMeasure() {
        this.startMeasure(true);
    }

    public void startMeasure(boolean deselectAll) {
        if (deselectAll) {
            this.deselectAll();
        }
        this.measureAtWork = true;
        logger.debug((Object)"start measure");
    }

    @Override
    public void endMeasure() {
        this.deselectAll();
        this.measureAtWork = false;
        this.measure = null;
        logger.debug((Object)"end measure");
    }

    public void stopMeasure() {
        this.measureAtWork = false;
    }

    public void restartMeasure() {
        this.measureAtWork = true;
    }

    @Override
    public void selected(AtomObject obj) {
        int i;
        if (this.atomSelectionCanvas != null) {
            i = 0;
            while (i < this.atomSelectionCanvas.size()) {
                ((AtomSelectionCanvas)this.atomSelectionCanvas.get(i)).selected(obj);
                ++i;
            }
        }
        this.selectedAtoms.push(obj);
        if (this.measure == null || this.measure.getNumberOfNecessaryAtoms() < 0) {
            return;
        }
        if (this.measureAtWork && this.selectedAtoms.size() >= this.measure.getNumberOfNecessaryAtoms()) {
            this.measure.measure(this.selectedAtoms);
            this.measure.draw();
            this.deselectAll();
            if (this.measureListeners != null) {
                i = 0;
                while (i < this.measureListeners.size()) {
                    MeasureListener list = (MeasureListener)this.measureListeners.get(i);
                    list.measured(this.measure);
                    ++i;
                }
            }
        }
    }

    private void doBond() {
    }

    public void removeMeasureObjects() {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof MeasureBranchGroup)) continue;
            ((MeasureBranchGroup)((Object)obj)).detach();
        }
        if (this.measures != null) {
            int i = this.measures.size() - 1;
            while (i <= 0) {
                Object obj = this.measures.get(i);
                this.measures.remove(i);
                Object var3_4 = null;
                --i;
            }
        }
    }

    public void updateMeasureObjects() {
        if (this.measures == null) {
            return;
        }
        int i = 0;
        while (i < this.measures.size()) {
            ((Measure)this.measures.get(i)).update(this.getAtomObjects());
            if (this.measureListeners != null) {
                int j = 0;
                while (j < this.measureListeners.size()) {
                    ((MeasureListener)this.measureListeners.get(j)).measureUpdated((Measure)this.measures.get(i));
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void addShape(BranchGroup shape) {
        this.addChild((Node)shape);
    }

    @Override
    public SceneGraphElementCreator getCreator() {
        return this.creator;
    }

    @Override
    public void deselected(AtomObject obj) {
        if (this.selectedAtoms.remove(obj)) {
            logger.debug((Object)("removed atom " + obj.getID() + " from 'selected' list"));
        }
        if (this.atomSelectionCanvas != null) {
            int i = 0;
            while (i < this.atomSelectionCanvas.size()) {
                ((AtomSelectionCanvas)this.atomSelectionCanvas.get(i)).deselected(obj);
                ++i;
            }
        }
    }

    @Override
    public void deselectAll() {
        AtomObject[] selected = this.getSelectedAtoms();
        if (selected == null) {
            return;
        }
        logger.debug((Object)"removing all atoms.");
        int n = selected.length;
        int i = 0;
        while (i < n) {
            selected[i].unSelect();
            if (this.atomSelectionCanvas != null) {
                int j = 0;
                while (j < this.atomSelectionCanvas.size()) {
                    ((AtomSelectionCanvas)this.atomSelectionCanvas.get(j)).deselected(selected[i]);
                    ++j;
                }
            }
            ++i;
        }
        BranchGroup root = this.mp.getRootBranch();
        Enumeration enu = root.getAllChildren();
        this.selectedAtoms = new Stack();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MyMouseTranslate)) continue;
            ((MyMouseTranslate)((Object)object)).clear();
            ((Behavior)object).setEnable(true);
        }
    }

    public void setRotationEnabled(boolean enable) {
        BranchGroup root = this.mp.getRootBranch();
        Enumeration enu = root.getAllChildren();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MyMouseRotate)) continue;
            ((MyMouseRotate)((Object)object)).init();
            ((Behavior)object).setEnable(enable);
        }
    }

    @Override
    public double getLenMax() {
        return this.mCD.getLenMax();
    }

    @Override
    public double[] getCOM() {
        return this.mCD.getCOM();
    }

    @Override
    public void cleanUp() {
        if (this.bonds != null) {
            int i = 0;
            while (i < this.bonds.size()) {
                ((BondInfo)this.bonds.get(i)).nullify();
                ++i;
            }
            this.bonds.clear();
            this.bonds = null;
        }
        if (this.mCD != null && this.mCD.getAtomCoords() != null) {
            this.mCD.getAtomCoords().nullify();
        }
        this.Dpos = null;
        if (this.mp != null && this.mp.getFramesAC() != null) {
            Vector vec = this.mp.getFramesAC();
            int i = 0;
            while (i < vec.size()) {
                AtomCoords co = (AtomCoords)vec.get(i);
                co.nullify();
                Object var3_4 = null;
                ++i;
            }
            vec.clear();
        }
    }

    public void setSceneGraphElementCreator(SceneGraphElementCreator creator) {
        this.creator = creator;
        this.mCD = creator.getConfigData();
        this.mACVD = creator.getACVData();
        this.mCD.register(this);
    }

    public ConfigDataManager getConfigData() {
        return this.creator.getConfigData();
    }

    public J3DDataManager getACVData() {
        return this.creator.getACVData();
    }

    public void create() {
        this.prepare(true);
        this.addAtoms();
        this.addBond();
        this.addHbonds();
        this.addCell();
    }

    public void restoreSelection(int last, int[] selectedBuffer) {
        logger.debug((Object)"restoreing selection...");
        logger.debug((Object)("numat now: " + this.mCD.getNumAt() + ", previous numat: " + last));
        if (selectedBuffer == null || selectedBuffer.length == 0) {
            return;
        }
        logger.debug((Object)("size of 'selected' buffer: " + selectedBuffer.length));
        if (this.mCD.getNumAt() == last) {
            AtomObject[] atoms = this.getAtomObjects();
            if (atoms == null || selectedBuffer == null) {
                return;
            }
            int i = 0;
            while (i < atoms.length) {
                int j = 0;
                while (j < selectedBuffer.length) {
                    if (Integer.parseInt(atoms[i].getID()) - 1 == selectedBuffer[j]) {
                        atoms[i].setSelected();
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void prepare() {
        this.prepare(false);
    }

    public void prepare(boolean rescaleOnUpdate) {
        this.NumAt = this.mCD.getNumAt();
        double[][] DposOrig = this.mCD.getPos();
        if (DposOrig == null) {
            return;
        }
        this.Dpos = new double[this.NumAt][3];
        int i = 0;
        while (i < this.NumAt) {
            int j = 0;
            while (j < 3) {
                this.Dpos[i][j] = DposOrig[i][j];
                ++j;
            }
            ++i;
        }
        if (rescaleOnUpdate) {
            this.mCD.doShiftScale();
        }
        double lenmax = this.mCD.getLenMax();
        double[] COM = this.mCD.getCOM();
        int i2 = 0;
        while (i2 < this.NumAt) {
            int j = 0;
            while (j < 3) {
                double foo = this.Dpos[i2][j];
                foo -= COM[j];
                this.Dpos[i2][j] = foo /= lenmax;
                ++j;
            }
            ++i2;
        }
        this.Dforce = this.mCD.getForce();
    }

    public double[] getCellOffset() {
        return this.cellOffset;
    }

    private boolean[] applyPBC(double[][] coords) {
        float[][] ce = this.getEffectiveBounds();
        double[][] ced = new double[3][3];
        double[][] sced = new double[3][3];
        double[][] plane01 = new double[2][3];
        double[][] plane02 = new double[2][3];
        double[][] plane12 = new double[2][3];
        this.lenmax = this.mCD.getLenMax();
        double[] foo = this.mCD.getCOM();
        double[] orig = new double[3];
        double[] coff = this.getCellOffset();
        double[] corig = this.mCD.getCellOriginVector();
        int i = 0;
        while (i < foo.length) {
            orig[i] = corig[i] + coff[i] * this.lenmax;
            logger.debug((Object)("cell offset, cell origin, jusin: " + coff[i] + ", " + corig[i] / this.lenmax + ", " + foo[i] / this.lenmax));
            ++i;
        }
        i = 0;
        while (i < 3) {
            ced[0][i] = (double)ce[0][i] * this.lenmax;
            ced[1][i] = (double)ce[1][i] * this.lenmax;
            ced[2][i] = (double)ce[2][i] * this.lenmax;
            sced[0][i] = ced[0][i] + orig[i];
            sced[1][i] = ced[1][i] + orig[i];
            sced[2][i] = ced[2][i] + orig[i];
            plane01[0][i] = ced[0][i];
            plane01[1][i] = ced[1][i];
            plane02[0][i] = ced[2][i];
            plane02[1][i] = ced[0][i];
            plane12[0][i] = ced[1][i];
            plane12[1][i] = ced[2][i];
            ++i;
        }
        int shifted = 0;
        boolean[] bshifted = new boolean[coords.length];
        int i2 = 0;
        while (i2 < coords.length) {
            int j;
            double[] pos = coords[i2];
            int j2 = 0;
            while (j2 < 3) {
                int n = j2;
                pos[n] = pos[n] - foo[j2];
                ++j2;
            }
            double r01 = VectorOperations.getDistanceFromPlane(pos, plane01[0], plane01[1], orig, true);
            double r10 = VectorOperations.getDistanceFromPlane(pos, plane01[1], plane01[0], sced[2], true);
            double r02 = VectorOperations.getDistanceFromPlane(pos, plane02[0], plane02[1], orig, true);
            double r20 = VectorOperations.getDistanceFromPlane(pos, plane02[1], plane02[0], sced[1], true);
            double r12 = VectorOperations.getDistanceFromPlane(pos, plane12[0], plane12[1], orig, true);
            double r21 = VectorOperations.getDistanceFromPlane(pos, plane12[1], plane12[0], sced[0], true);
            if (r01 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] + ced[2][j];
                    ++j;
                }
            } else if (r10 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] - ced[2][j];
                    ++j;
                }
            }
            if (r02 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] + ced[1][j];
                    ++j;
                }
            } else if (r20 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] - ced[1][j];
                    ++j;
                }
            }
            if (r12 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] + ced[0][j];
                    ++j;
                }
            } else if (r21 < 0.0) {
                ++shifted;
                bshifted[i2] = true;
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] - ced[0][j];
                    ++j;
                }
            }
            j = 0;
            while (j < 3) {
                int n = j;
                pos[n] = pos[n] + foo[j];
                ++j;
            }
            coords[i2] = pos;
            ++i2;
        }
        logger.debug((Object)("shifted atoms count: " + shifted));
        return bshifted;
    }

    private boolean[] doShift() {
        float[][] ce = this.getEffectiveBounds();
        if (ce == null) {
            return null;
        }
        VolumetricData[] vdata = this.mp.getAssociatedVolumetricData();
        if (vdata != null) {
            logger.debug((Object)"vdata update start");
            int n1 = (int)((double)vdata[0].getNumDiv()[0] * this.atomOffset.x);
            int n2 = (int)((double)vdata[0].getNumDiv()[1] * this.atomOffset.y);
            int n3 = (int)((double)vdata[0].getNumDiv()[2] * this.atomOffset.z);
            this.atomOffset.x = (double)n1 / ((double)vdata[0].getNumDiv()[0] - 1.0);
            this.atomOffset.y = (double)n2 / ((double)vdata[0].getNumDiv()[1] - 1.0);
            this.atomOffset.z = (double)n3 / ((double)vdata[0].getNumDiv()[2] - 1.0);
            logger.debug((Object)"vdata update end");
        }
        double xoff = this.atomOffset.x * (double)ce[0][0] + this.atomOffset.y * (double)ce[1][0] + this.atomOffset.z * (double)ce[2][0];
        double yoff = this.atomOffset.x * (double)ce[0][1] + this.atomOffset.y * (double)ce[1][1] + this.atomOffset.z * (double)ce[2][1];
        double zoff = this.atomOffset.x * (double)ce[0][2] + this.atomOffset.y * (double)ce[1][2] + this.atomOffset.z * (double)ce[2][2];
        logger.debug((Object)("offset: " + xoff + ", " + yoff + ", " + zoff));
        Transform3D currtrans = new Transform3D();
        this.getTransform(currtrans);
        Vector3d tra = new Vector3d();
        currtrans.get(tra);
        Matrix3d rot = new Matrix3d();
        currtrans.get(rot);
        rot.invert();
        rot.transform((Tuple3d)tra);
        tra.add((Tuple3d)new Vector3d(xoff, yoff, zoff));
        rot.invert();
        rot.transform((Tuple3d)tra);
        currtrans.setTranslation(new Vector3d(tra));
        this.setTransform(currtrans);
        CellObject co = this.getCellObject();
        if (co != null) {
            logger.debug((Object)"shifting cell back.");
            TransformGroup[] cs = co.getTransforms();
            co.detach();
            this.addChild((Node)co);
            int i = 0;
            while (i < cs.length) {
                cs[i].getTransform(currtrans);
                currtrans.get(tra);
                tra.sub((Tuple3d)new Vector3d(xoff, yoff, zoff));
                currtrans.setTranslation(tra);
                cs[i].setTransform(currtrans);
                ++i;
            }
        }
        this.cellOffset[0] = this.cellOffset[0] - xoff;
        this.cellOffset[1] = this.cellOffset[1] - yoff;
        this.cellOffset[2] = this.cellOffset[2] - zoff;
        AtomObject[] as = this.getAtomObjects();
        double[] com = this.mCD.getCOM();
        double len = this.mCD.getLenMax();
        double[][] newcoords = this.mCD.getPos();
        boolean[] valid = this.applyPBC(newcoords);
        this.getConfigData().getAtomCoords().setPosDouble(newcoords);
        this.atomOffset = this.zero;
        return valid;
    }

    public void atomUpdate() {
        logger.debug((Object)"updating atom...");
        boolean[] valid = new boolean[this.getAtomObjects().length];
        int i = 0;
        while (i < valid.length) {
            valid[i] = true;
            ++i;
        }
        if (!this.atomOffset.epsilonEquals((Tuple3d)this.zero, 0.0) && (valid = this.doShift()) == null) {
            logger.error((Object)"invalid cell...");
            return;
        }
        AtomStateList state = this.getConfigData().getAtomCoords().getAtomState();
        if (state == null) {
            if (this.mCD.forceUpdate()) {
                this.mCD.setScaleAtom(this.mACVD.getScaleAtom());
            }
            AtomObject[] aobj = this.getAtomObjects();
            int i2 = 0;
            while (i2 < aobj.length) {
                if (valid[i2]) {
                    aobj[i2].configDataUpdate();
                }
                ++i2;
            }
            logger.debug((Object)"done atom update");
            return;
        }
        logger.debug((Object)"num. atoms may have changed...");
        AtomObjectBG[] obj = this.getAtomObjectBGs();
        this.elements = this.mCD.getAtomCoords().getElements();
        this.auxils = this.mCD.getAtomCoords().getAuxils();
        AtomState[] res = state.getResults();
        int i3 = 0;
        while (i3 < res.length) {
            if (res[i3].origIndex < obj.length) {
                if (res[i3].mode == AtomState.REMOVED) {
                    obj[res[i3].origIndex].detach();
                    obj[res[i3].origIndex] = null;
                }
                if (res[i3].mode == AtomState.MODIFIED) {
                    obj[res[i3].origIndex].getAssociatedAtomObject().setID(res[i3].index + 1);
                    obj[res[i3].origIndex].getAssociatedAtomObject().configDataUpdate();
                }
                if (res[i3].mode == AtomState.UNCHANGED) {
                    obj[res[i3].origIndex].getAssociatedAtomObject().setID(res[i3].index + 1);
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < res.length) {
            if (res[i3].mode == AtomState.ADDED) {
                int ind = res[i3].index;
                logger.debug((Object)("adding atom : " + ind));
                BranchGroup bg = this.createAtom(ind);
                if (bg == null) {
                    logger.debug((Object)("null atom at : " + ind));
                } else if (ind >= this.atomBranchGroup.numChildren()) {
                    this.atomBranchGroup.addChild((Node)bg);
                } else {
                    this.atomBranchGroup.insertChild((Node)bg, ind);
                }
            }
            ++i3;
        }
        int[] map = state.getIndexMap();
        int i4 = 0;
        while (i4 < this.bonds.size()) {
            BondInfo inf = (BondInfo)this.bonds.get(i4);
            int[] pair = inf.getIndexPair();
            logger.debug((Object)("old index pair & new index pair: " + pair[0] + ", " + pair[1] + "  :  " + map[pair[0]] + ", " + map[pair[1]]));
            pair[0] = map[pair[0]];
            pair[1] = map[pair[1]];
            inf.setIndexPair(pair[0], pair[1]);
            ++i4;
        }
        logger.debug((Object)"done atom update");
    }

    private BranchGroup createAtom(int i) {
        int atomicNumber = 1;
        if (i >= this.elements.length || this.elements[i] == null || this.elements[i].length() == 0) {
            return null;
        }
        int j = 0;
        while (j < this.mACVD.getNumEl()) {
            if (this.elements[i].equals(this.mACVD.getElement()[j])) {
                atomicNumber = j;
            }
            ++j;
        }
        int[] mw = TGAtom.getMobileAndWeight(this.auxils, i);
        int mobile = mw[0];
        int weight = mw[1];
        String ID = new Integer(i + 1).toString();
        BranchGroup at = this.creator.getSceneGraphElement(ID, atomicNumber, this.Dpos[i], this.Dforce[i], mobile, weight);
        ((AtomObjectBG)at).getAssociatedAtomObject().register(this.mCD, this.mACVD, this);
        return at;
    }

    public static int[] getMobileAndWeight(TaggedString[][] auxs, int i) {
        int mobile = 0;
        int weight = 1;
        try {
            int au = 0;
            while (au < auxs[0].length) {
                TaggedString ts = auxs[i][au];
                if (ts.getTag().trim().equalsIgnoreCase("mobile")) {
                    try {
                        mobile = Integer.parseInt(ts.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (ts.getTag().trim().equalsIgnoreCase("weight")) {
                    try {
                        weight = Integer.parseInt(ts.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++au;
            }
        }
        catch (NullPointerException npe) {
            mobile = 0;
            weight = 1;
        }
        return new int[]{mobile, weight};
    }

    private void addAtoms() {
        this.atomBranchGroup = new BranchGroup();
        this.atomBranchGroup.setCapability(12);
        this.atomBranchGroup.setCapability(13);
        this.atomBranchGroup.setCapability(14);
        this.atomTransformGroup = new TransformGroup();
        this.atomTransformGroup.setCapability(17);
        this.atomTransformGroup.setCapability(18);
        this.atomTransformGroup.addChild((Node)this.atomBranchGroup);
        this.elements = this.mCD.getElements();
        this.auxils = this.mCD.getAuxils();
        this.mCD.setScaleAtom(this.mACVD.getScaleAtom());
        int i = 0;
        while (i < this.NumAt) {
            BranchGroup bg = this.createAtom(i);
            if (bg != null) {
                this.atomBranchGroup.addChild((Node)bg);
            }
            ++i;
        }
        this.addChild((Node)this.atomTransformGroup);
    }

    private void HbondUpdate() {
        if (!new Boolean(this.props.getProperty("hbond_draw_hbonds")).booleanValue()) {
            if (this.Hbonds != null) {
                int i = this.Hbonds.size() - 1;
                while (i >= 0) {
                    BondInfo binf = (BondInfo)this.Hbonds.get(i);
                    int[] indpair = binf.getIndexPair();
                    double crtdst = binf.getCriticalDistanceSquared();
                    double[] at1 = this.Dpos[indpair[0]];
                    double[] at2 = this.Dpos[indpair[1]];
                    BondObject oj = binf.getBond();
                    binf.getBond().detach();
                    this.Hbonds.removeElementAt(i);
                    oj = null;
                    binf = null;
                    --i;
                }
                this.Hbonds = null;
            }
            return;
        }
        if (this.Hbonds == null) {
            this.addHbonds();
            return;
        }
        boolean[][] ignore = new boolean[this.NumAt][this.NumAt];
        double[][] postmp = this.getScaledPos();
        int i = this.Hbonds.size() - 1;
        while (i >= 0) {
            BondInfo binf = (BondInfo)this.Hbonds.get(i);
            int[] indpair = binf.getIndexPair();
            if (indpair[0] >= postmp.length || indpair[1] >= postmp.length || indpair[0] < 0 || indpair[1] < 0) {
                this.remBond(binf, i);
            } else {
                double[] at2;
                double[] at1;
                double crtdst = binf.getCriticalDistanceSquared();
                if (crtdst < Math.pow((at1 = postmp[indpair[0]])[0] - (at2 = postmp[indpair[1]])[0], 2.0) + Math.pow(at1[1] - at2[1], 2.0) + Math.pow(at1[2] - at2[2], 2.0)) {
                    BondObject oj = binf.getBond();
                    binf.getBond().detach();
                    this.Hbonds.removeElementAt(i);
                    oj = null;
                    binf = null;
                } else {
                    binf.getBond().recreate(new double[]{at1[0], at1[1], at1[2], at2[0], at2[1], at2[2]});
                }
                ignore[indpair[0]][indpair[1]] = true;
            }
            --i;
        }
        this.hbondCalculator.setIgnore(ignore);
        this.hbondCalculator.doHbond(postmp);
        Vector foo = this.hbondCalculator.getBonds();
        int i2 = 0;
        while (i2 < foo.size()) {
            BondInfo binf = (BondInfo)foo.get(i2);
            double[] NearestNeighbor_ = binf.getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_, BondObject.HBOND);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
            this.Hbonds.addElement(binf);
            ++i2;
        }
    }

    private void remBond(BondInfo binf, int i) {
        BondObject obj = binf.getBond();
        binf.getBond().detach();
        if (i < this.bonds.size()) {
            this.bonds.removeElementAt(i);
        }
        obj = null;
        binf = null;
    }

    /*
     * Unable to fully structure code
     */
    private void bondUpdate() {
        if (this.bonds == null) {
            return;
        }
        ignore = new boolean[this.NumAt][this.NumAt];
        atomObjects = this.getAtomObjects();
        if (this.mCD.forceUpdate()) {
            i = this.bonds.size() - 1;
            while (i >= 0) {
                binf = (BondInfo)this.bonds.get(i);
                this.remBond(binf, i);
                --i;
            }
        }
        postmp = this.getScaledPos();
        i = this.bonds.size() - 1;
        while (i >= 0) {
            block10: {
                block9: {
                    binf = (BondInfo)this.bonds.get(i);
                    indpair = binf.getIndexPair();
                    crtdst = binf.getCriticalDistanceSquared();
                    if (indpair[0] < postmp.length && indpair[1] < postmp.length && indpair[0] >= 0 && indpair[1] >= 0) break block9;
                    this.remBond(binf, i);
                    break block10;
                }
                at1 = postmp[indpair[0]];
                at2 = postmp[indpair[1]];
                if (this.updateMode != TGAtom.GENERIC) ** GOTO lbl31
                atnum1 = this.mCD.getAtomicNumber(indpair[0]) - 1;
                atnum2 = this.mCD.getAtomicNumber(indpair[1]) - 1;
                if (atnum1 < 0 || atnum2 < 0) {
                    this.remBond(binf, i);
                } else {
                    crtdst = Math.pow(this.mACVD.getBondFactor() * (this.mACVD.getCovRad()[atnum1] + this.mACVD.getCovRad()[atnum2]) / this.mCD.getLenMax(), 2.0);
lbl31:
                    // 2 sources

                    if (crtdst < Math.pow(at1[0] - at2[0], 2.0) + Math.pow(at1[1] - at2[1], 2.0) + Math.pow(at1[2] - at2[2], 2.0)) {
                        this.remBond(binf, i);
                    } else {
                        binf.getBond().recreate(new double[]{at1[0], at1[1], at1[2], at2[0], at2[1], at2[2]});
                        ignore[indpair[0]][indpair[1]] = true;
                    }
                }
            }
            --i;
        }
        this.clcbnd.setIgnore(ignore);
        this.clcbnd.doIt(postmp);
        foo = this.clcbnd.getBonds();
        i = 0;
        while (i < foo.size()) {
            binf = (BondInfo)foo.get(i);
            NearestNeighbor_ = binf.getCoordinates();
            bond = this.creator.getSceneGraphElement(NearestNeighbor_);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
            this.bonds.addElement(binf);
            ++i;
        }
    }

    private void addBond() {
        this.clcbnd = new BondCalculator(this.mACVD, this.mCD);
        double[][] dp = this.mCD.getPos();
        double[][] postmp = this.getScaledPos();
        this.clcbnd.doIt(postmp);
        this.bonds = this.clcbnd.getBonds();
        int i = 0;
        while (i < this.bonds.size()) {
            BondInfo binf = (BondInfo)this.bonds.get(i);
            double[] NearestNeighbor_ = binf.getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
            ++i;
        }
    }

    private double[][] getScaledPos() {
        double[][] dp = this.mCD.getPos();
        double[][] postmp = new double[dp.length][3];
        int i = 0;
        while (i < postmp.length) {
            int j = 0;
            while (j < 3) {
                postmp[i][j] = (dp[i][j] - this.mCD.getCOM()[j]) / this.mCD.getLenMax();
                ++j;
            }
            ++i;
        }
        return postmp;
    }

    private void addHbonds() {
        if (!new Boolean(this.props.getProperty("hbond_draw_hbonds")).booleanValue()) {
            return;
        }
        this.hbondCalculator = new BondCalculator(this.mACVD, this.mCD);
        this.hbondCalculator.doHbond(this.Dpos);
        this.Hbonds = this.hbondCalculator.getBonds();
        if (this.Hbonds == null) {
            return;
        }
        logger.debug((Object)("num hbonds: " + this.Hbonds.size()));
        int i = 0;
        while (i < this.Hbonds.size()) {
            BondInfo binf = (BondInfo)this.Hbonds.get(i);
            logger.debug((Object)("bond info; bondlength: " + binf.getBondLength() * this.mCD.getLenMax()));
            double[] NearestNeighbor_ = binf.getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_, BondObject.HBOND);
            binf.setBond((BondObject)bond);
            this.addChild((Node)bond);
            ++i;
        }
    }

    private void addCell() {
        logger.debug((Object)"at addCell()");
        if (this.cellObject != null) {
            this.cellObject.detach();
        }
        if (this.mACVD.getDrawCell()) {
            this.cellObject = this.creator.getSceneGraphElementBG(2);
            this.addChild((Node)this.cellObject);
        }
    }

    public int getSelectedAtomCount() {
        int ret = 0;
        AtomObject[] aobjs = this.getAtomObjects();
        if (aobjs == null) {
            return ret;
        }
        int i = 0;
        while (i < aobjs.length) {
            if (aobjs[i].isSelected()) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public int[] getSelectedAtomsIndex() {
        Vector<String> vret = new Vector<String>();
        AtomObject[] aobjs = this.getAtomObjects();
        if (aobjs == null) {
            return null;
        }
        int i = 0;
        while (i < aobjs.length) {
            if (aobjs[i].isSelected()) {
                vret.addElement(aobjs[i].getID());
            }
            ++i;
        }
        if (vret.size() == 0) {
            return null;
        }
        int[] ret = new int[vret.size()];
        i = 0;
        while (i < vret.size()) {
            ret[i] = Integer.parseInt((String)vret.elementAt(i)) - 1;
            ++i;
        }
        return ret;
    }

    public void setRescaleOnUpdate(boolean rescaleOnUpdate) {
        this.rescaleOnUpdate = rescaleOnUpdate;
    }

    public boolean getRescaleOnUpdate() {
        return this.rescaleOnUpdate;
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    public void configDataUpdate() {
        logger.debug((Object)"start bond update");
        this.bondUpdate();
        this.HbondUpdate();
        this.doBond();
        logger.debug((Object)"end bond update");
        this.updateMeasureObjects();
        if (this.mCD.forceUpdate()) {
            this.addCell();
        }
    }

    public int getLastNumAt() {
        int last = this.mCD.getNumAt();
        logger.debug((Object)("stored selection; numat now: " + last));
        return last;
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    public DynamicallyEditable[] getDynamicallyEditableElements() {
        Vector<DynamicallyEditable> retvec = new Vector<DynamicallyEditable>();
        AtomObject[] aobjs = this.getAtomObjects();
        BondObject[] bobjs = this.getBondObjects();
        int i = 0;
        while (i < aobjs.length) {
            retvec.addElement(aobjs[i]);
            ++i;
        }
        if (bobjs != null) {
            i = 0;
            while (i < bobjs.length) {
                retvec.addElement(bobjs[i]);
                ++i;
            }
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new DynamicallyEditable[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }

    public CellObject getCellObject() {
        int i = 0;
        while (i < this.numChildren()) {
            if (this.getChild(i) instanceof CellObject) {
                return (CellObject)this.getChild(i);
            }
            ++i;
        }
        return null;
    }

    private BondObject[] getBondObjects() {
        Vector<Node> retvec = new Vector<Node>();
        int i = 0;
        while (i < this.numChildren()) {
            if (this.getChild(i) instanceof BondObject) {
                retvec.addElement(this.getChild(i));
            }
            ++i;
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new BondObject[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }

    public AtomObjectBG[] getAtomObjectBGs() {
        Vector<Node> retvec = new Vector<Node>();
        int i = 0;
        while (i < this.atomBranchGroup.numChildren()) {
            retvec.addElement(this.atomBranchGroup.getChild(i));
            ++i;
        }
        if (retvec.size() == 0) {
            return null;
        }
        AtomObjectBG[] rets = new AtomObjectBG[retvec.size()];
        retvec.copyInto((Object[])rets);
        return rets;
    }

    public AtomObject[] getAtomObjects() {
        Vector<Node> retvec = new Vector<Node>();
        int i = 0;
        while (i < this.atomBranchGroup.numChildren()) {
            retvec.addElement(this.atomBranchGroup.getChild(i));
            ++i;
        }
        if (retvec.size() == 0) {
            return null;
        }
        AtomObject[] rets = new AtomObject[retvec.size()];
        int i2 = 0;
        while (i2 < rets.length) {
            rets[i2] = ((AtomObjectBG)((Object)retvec.get(i2))).getAssociatedAtomObject();
            ++i2;
        }
        return rets;
    }

    public AtomObject[] getSelectedAtoms() {
        AtomObject[] all = this.getAtomObjects();
        if (all == null) {
            return null;
        }
        Vector<AtomObject> retvec = new Vector<AtomObject>();
        int i = 0;
        while (i < all.length) {
            if (all[i].isSelected()) {
                retvec.addElement(all[i]);
            }
            ++i;
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new AtomObject[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }
}

