/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.mouselistener;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.mouselistener.MouseMotionListenerAction;
import ciss.phase_viewer.acviewer.mouselistener.MouseMotionListenerManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.apache.log4j.Logger;

public class ACVMouseMotionListener
implements MouseMotionListener,
MouseListener {
    private Logger logger = Logger.getLogger((String)ACVMouseMotionListener.class.getName());
    private CoordsViewerInterface parent;
    private MouseMotionListenerManager manager;

    public ACVMouseMotionListener(MainPanel parent) {
        this.parent = parent;
        this.manager = new MouseMotionListenerManager(parent);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MouseMotionListenerAction action = this.manager.getAction(e);
        if (action == null) {
            this.logger.debug((Object)("action for " + MouseEvent.getMouseModifiersText(e.getModifiersEx()) + " not implemented yet."));
            return;
        }
        action.processMouseDrag(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ((MainPanel)this.parent).getJCanvas3D().requestFocusInWindow();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MouseMotionListenerAction action = this.manager.getAction(e);
        if (action == null) {
            this.logger.debug((Object)("action for " + MouseEvent.getMouseModifiersText(e.getModifiersEx()) + " not implemented yet."));
            return;
        }
        action.init(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MouseMotionListenerAction action = this.manager.getAction(e);
        if (action == null) {
            this.logger.debug((Object)("action for " + MouseEvent.getMouseModifiersText(e.getModifiersEx()) + " not implemented yet."));
            return;
        }
        action.finalize(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

