/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.keylistener;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class TranslateKeyListener
implements KeyListener,
PropertiesListener {
    private Logger logger = Logger.getLogger((String)TranslateKeyListener.class.getName());
    private TransformGroup[] tgroups;
    private double factor = 0.05;
    private Transform3D transx = new Transform3D();
    private Transform3D transy = new Transform3D();
    private Transform3D currTrans = new Transform3D();

    public TranslateKeyListener(TransformGroup[] tgroups) {
        PropertiesManager.getGlobalProperties(1);
        GlobalProperties.addPropertiesListener(this);
        this.tgroups = tgroups;
        try {
            this.factor = Double.parseDouble(PropertiesManager.getGlobalProperties(1).getProperty("keylistener_trans"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void doTranslation(int x, int y) {
        double dx = (double)x * this.factor;
        double dy = (double)y * this.factor;
        int i = 0;
        while (i < this.tgroups.length) {
            this.tgroups[i].getTransform(this.currTrans);
            Vector3d t3d = new Vector3d();
            this.currTrans.get(t3d);
            t3d.add((Tuple3d)new Vector3d(dx, dy, 0.0));
            this.currTrans.setTranslation(t3d);
            this.tgroups[i].setTransform(this.currTrans);
            ++i;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!e.isShiftDown()) {
            return;
        }
        if (e.isAltDown()) {
            return;
        }
        if (e.getKeyCode() == 38 || e.getKeyCode() == 75) {
            this.doTranslation(0, 1);
        } else if (e.getKeyCode() == 40 || e.getKeyCode() == 74) {
            this.doTranslation(0, -1);
        } else if (e.getKeyCode() == 37 || e.getKeyCode() == 72) {
            this.doTranslation(-1, 0);
        } else if (e.getKeyCode() == 39 || e.getKeyCode() == 76) {
            this.doTranslation(1, 0);
        }
    }

    @Override
    public void propertiesStored(GlobalProperties properties) {
        try {
            this.factor = Double.parseDouble(properties.getProperty("keylistener_trans"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

