/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import Jama.Matrix;
import ciss.phase_viewer.acviewer.fbz.FBZUtils;
import ciss.phase_viewer.acviewer.fbz.SymmetryPoint;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import java.text.DecimalFormat;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SymmetryPointBG
extends BranchGroup {
    private Vector3f position;
    private Color3f selectedColor = new Color3f(1.0f, 0.8f, 0.4f);
    private Color3f unselectedColor = new Color3f(0.0f, 0.2f, 0.6f);
    private Appearance appearance;
    private Material material;
    private SymmetryPoint point;
    private WignerSeitzAttributes wsattrs;
    private Point3f[] lat;
    private String symbol = "";
    private int[] xbunsu;
    private int[] ybunsu;
    private int[] zbunsu;
    private Point3f scaledPos;
    private DecimalFormat format = new DecimalFormat("0.000");

    public SymmetryPointBG(Vector3f position, Point3f[] lat, WignerSeitzAttributes wsattrs) {
        this.position = position;
        this.lat = lat;
        this.wsattrs = wsattrs;
        float rad = 0.0f;
        if (wsattrs != null) {
            rad = wsattrs.symmetricPointRadius;
        }
        this.point = new SymmetryPoint(rad, wsattrs);
        this.point.setBG(this);
        TransformGroup tg = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(position);
        tg.setTransform(t3d);
        tg.addChild((Node)this.point);
        this.addChild((Node)tg);
        this.setCapability(1);
    }

    public void setSelected(boolean selected) {
        this.point.setSelected(selected);
    }

    public boolean isSelected() {
        return this.point.isSelected();
    }

    public SymmetryPoint getPoint() {
        return this.point;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    private void generateBunsuCoords() {
        double[][] bmat = new double[3][3];
        double[][] kmat = new double[3][1];
        kmat[0][0] = this.position.x;
        kmat[1][0] = this.position.y;
        kmat[2][0] = this.position.z;
        int i = 0;
        while (i < 3) {
            bmat[0][i] = this.lat[i].x;
            bmat[1][i] = this.lat[i].y;
            bmat[2][i] = this.lat[i].z;
            ++i;
        }
        Matrix B = new Matrix(bmat);
        Matrix K = new Matrix(kmat);
        Matrix S = B.solve(K);
        int[] xbunsu__ = FBZUtils.getBunsu((float)S.get(0, 0));
        int[] ybunsu__ = FBZUtils.getBunsu((float)S.get(1, 0));
        int[] zbunsu__ = FBZUtils.getBunsu((float)S.get(2, 0));
        this.scaledPos = new Point3f();
        this.scaledPos.x = (float)S.get(0, 0);
        this.scaledPos.y = (float)S.get(1, 0);
        this.scaledPos.z = (float)S.get(2, 0);
        this.xbunsu = new int[]{xbunsu__[1], xbunsu__[2]};
        this.ybunsu = new int[]{ybunsu__[1], ybunsu__[2]};
        this.zbunsu = new int[]{zbunsu__[1], zbunsu__[2]};
    }

    public int[][] getBunsuCoords() {
        if (this.xbunsu == null || this.ybunsu == null || this.zbunsu == null) {
            this.generateBunsuCoords();
        }
        return new int[][]{this.xbunsu, this.ybunsu, this.zbunsu};
    }

    public Point3f getScaledPos() {
        if (this.scaledPos == null) {
            this.generateBunsuCoords();
        }
        return this.scaledPos;
    }

    public Vector3f getPos() {
        return this.position;
    }

    public String toString() {
        if (this.xbunsu == null || this.ybunsu == null || this.zbunsu == null) {
            this.generateBunsuCoords();
        }
        String str = "pos: " + this.xbunsu[0] + "/" + this.xbunsu[1] + ", " + this.ybunsu[0] + "/" + this.ybunsu[1] + ", " + this.zbunsu[0] + "/" + this.zbunsu[1];
        return str;
    }
}

