/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.ACVButtons;
import ciss.phase_viewer.acviewer.ACVMenuBar;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.fbz.FBZData;
import ciss.phase_viewer.acviewer.fbz.FBZTransform;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointPicker;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.acviewer.keylistener.J3DKeyListener;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseRotate;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseTranslate;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.atomcoord.VolumetricData;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import java.awt.Component;
import java.awt.event.KeyListener;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class FBZ
extends BaseJ3DPanel {
    private Logger logger = Logger.getLogger((String)FBZ.class.getName());
    private float[][] reciprocalLatticeVector = new float[3][3];
    private Transform3D translateorigin = new Transform3D();
    private FBZData data;
    private float scale = -100.0f;
    private float scalescale = 1.2f;
    private WignerSeitzCell wscell;
    private ChaseTransformGroup rootTransform;
    private TransformGroup objTransformAxis;
    private ACVButtons btns;

    public FBZ(double[][] vec) {
        super("FBZ viewer", defaultSize);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.reciprocalLatticeVector[i][j] = (float)vec[i][j];
                ++j;
            }
            ++i;
        }
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
        this.setVisible(true);
    }

    public FBZ(FBZData data) {
        super("FBZ viewer", defaultSize);
        this.data = data;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.reciprocalLatticeVector[i][j] = (float)data.reciprocalLattice[i][j];
                ++j;
            }
            ++i;
        }
        this.parentDir = data.baseDir;
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
        this.setVisible(true);
    }

    public FBZData getFBZData() {
        return this.data;
    }

    @Override
    public boolean supportsFrame() {
        return false;
    }

    public float[][] getReciprocalLatticeVector() {
        return this.reciprocalLatticeVector;
    }

    @Override
    protected String getExportFileNamePrefix() {
        return "FBZ";
    }

    @Override
    protected String getPluginPath() {
        return "/ciss/phase_viewer/acviewer/fbz/plugins.xml";
    }

    @Override
    public TransformGroup getRootTransform() {
        return this.rootTransform;
    }

    @Override
    public TransformGroup[] getRotatingTransform() {
        return new TransformGroup[]{this.rootTransform, this.objTransformAxis};
    }

    private void init() {
        int j;
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                if (Math.abs(this.reciprocalLatticeVector[i][j]) > this.scale) {
                    this.scale = this.reciprocalLatticeVector[i][j];
                }
                ++j;
            }
            ++i;
        }
        this.scale *= this.scalescale;
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                float[] fArray = this.reciprocalLatticeVector[i];
                int n = j++;
                fArray[n] = fArray[n] / this.scale;
            }
            ++i;
        }
        this.translateorigin.set(new Vector3f(-0.8f, -0.7f, 0.0f));
        Point3f[] point3f = new Point3f[3];
        int i2 = 0;
        while (i2 < 3) {
            point3f[i2] = new Point3f(this.reciprocalLatticeVector[i2]);
            ++i2;
        }
        this.wscell = new WignerSeitzCell(point3f[0], point3f[1], point3f[2], this.parentDir, this.data.kpointGenerator);
        this.rootBranch = new BranchGroup();
        this.rootBranch.setCapability(17);
        this.rootBranch.setCapability(12);
        this.rootBranch.setCapability(13);
        this.rootBranch.setCapability(14);
        this.rootTransform = new FBZTransform(this);
        this.rootTransform.setCapability(12);
        this.rootTransform.setCapability(18);
        this.rootTransform.setCapability(17);
        this.rootTransform.setCapability(1);
        this.rootTransform.setCapability(14);
        this.rootTransform.setCapability(13);
        this.rootTransform.addChild((Node)this.wscell);
        this.rootBranch.addChild((Node)this.rootTransform);
        MyMouseRotate myMouseRotate = null;
        myMouseRotate = BaseJ3DPanel.useJCanvas3D() ? new MyMouseRotate(this.getJCanvas3D()) : new MyMouseRotate();
        myMouseRotate.setTransformGroup(this.rootTransform);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseRotate);
        MyMouseTranslate myMouseTranslate = null;
        myMouseTranslate = BaseJ3DPanel.useJCanvas3D() ? new MyMouseTranslate(this.getJCanvas3D()) : new MyMouseTranslate();
        myMouseTranslate.setTransformGroup(this.rootTransform);
        myMouseTranslate.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = null;
        myMouseZoom = BaseJ3DPanel.useJCanvas3D() ? new MouseZoom((Component)this.getJCanvas3D()) : new MouseZoom();
        myMouseZoom.setTransformGroup((TransformGroup)this.rootTransform);
        myMouseZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseZoom);
        MouseWheelZoom myMouseWheelZoom = null;
        myMouseWheelZoom = BaseJ3DPanel.useJCanvas3D() ? new MouseWheelZoom((Component)this.getJCanvas3D()) : new MouseWheelZoom();
        myMouseWheelZoom.setTransformGroup((TransformGroup)this.rootTransform);
        myMouseWheelZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseWheelZoom);
        J3DDataManager mACVD = new J3DDataManager();
        SceneGraphElementCreator creator = new SceneGraphElementCreator(mACVD, null);
        this.rootBranch.addChild((Node)creator.getSceneGraphElement(5));
        this.rootBranch.addChild((Node)creator.getSceneGraphElement(6));
        if (mACVD.getAxis()) {
            Transform3D translateorigin = new Transform3D();
            translateorigin.set(new Vector3f(-0.8f, -0.7f, 0.0f));
            this.objTransformAxis = creator.getSceneGraphElement(3);
            this.objTransformAxis.setTransform(translateorigin);
            MyMouseRotate myMouseRotateAxis = new MyMouseRotate();
            myMouseRotateAxis.setTransformGroup(this.objTransformAxis);
            myMouseRotateAxis.setSchedulingBounds((Bounds)new BoundingSphere());
            this.rootBranch.addChild((Node)myMouseRotateAxis);
            this.rootBranch.addChild((Node)this.objTransformAxis);
        }
        SymmetryPointPicker picker = new SymmetryPointPicker(this.canvas3d, this.rootBranch, (Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0), this.wscell);
        BranchGroup pickerBG = new BranchGroup();
        pickerBG.addChild((Node)picker);
        this.rootBranch.addChild((Node)pickerBG);
        KeyListener[] listeners = J3DKeyListener.getKeyListeners(this);
        int i3 = 0;
        while (i3 < listeners.length) {
            this.canvas3d.addKeyListener(listeners[i3]);
            ++i3;
        }
        this.rootBranch.compile();
        this.simpleU.addBranchGraph(this.rootBranch);
        if (this.btns == null) {
            this.btns = new ACVButtons(this);
            this.getContentPane().add((Component)this.btns, "North");
        }
    }

    public WignerSeitzCell getFBZ() {
        return this.wscell;
    }

    @Override
    public VolumetricData[] getAssociatedVolumetricData() {
        return this.getFBZData().eigenValues;
    }
}

