/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ImageReciver;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.vrml.VRMLExporter;
import ciss.phase_viewer.atomcoord.AtomCoords;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Animater
implements Runnable {
    public static final int ON_SCREEN = 0;
    public static final int EXPORT = 1;
    public static final int JPEG = 2;
    public static final int VRML = 3;
    private int batchImageMode = 2;
    private static Logger logger = Logger.getLogger((String)Animater.class.getName());
    private MainPanel parent;
    private ConfigDataManager mCD;
    private Vector frames;
    private int numFrames = 0;
    private int mode = 0;
    private boolean cyclic = false;
    private boolean sleep = false;
    private int frameRate = 10;
    private int skip = 1;
    private Vector images;
    private ImageReciver imageReciever;
    private String prefix = "frame";
    private boolean rescaleOnUpdate = false;
    private int currframe = 0;
    private String baseDir;
    private VRMLExporter vrmlExporter;

    public Animater(MainPanel parent) {
        this.parent = parent;
        this.init();
    }

    public Animater(J3DPanel j3d) {
        this.parent = (MainPanel)j3d;
    }

    public Animater(MainPanel parent, int mode) {
        this.parent = parent;
        this.mode = mode;
        this.init();
    }

    public void setBatchImageMode(int batchImageMode) {
        this.batchImageMode = batchImageMode;
    }

    public int getBatchImageMode() {
        return this.batchImageMode;
    }

    private void init() {
        this.frames = this.parent.getFramesAC();
        this.numFrames = this.frames.size();
        this.mCD = this.parent.getCD();
    }

    public void setSleep(boolean sleep) {
        this.sleep = sleep;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public void doAnim() {
        new Thread(new Anim()).start();
    }

    public int getCurrentFrame() {
        return this.currframe;
    }

    public void setFrame(int currentFrame) {
        if (currentFrame >= this.frames.size() || currentFrame < 0) {
            return;
        }
        this.currframe = currentFrame;
        this.parent.doRedraw(false);
        ((TGAtom)this.parent.getScene().getTGAtom()).setUpdateMode(TGAtom.ANIM);
        AtomCoords coords = (AtomCoords)this.frames.get(currentFrame);
        this.mCD.setCoords(coords, this.rescaleOnUpdate);
        this.mCD.setFrameNum(currentFrame);
        ((TGAtom)this.parent.getScene().getTGAtom()).updateMeasureObjects();
        this.parent.doRedraw(true);
        if (this.sleep) {
            try {
                Thread.sleep(this.frameRate);
            }
            catch (InterruptedException ie) {
                logger.warn((Object)"failed pause");
            }
        }
        ((TGAtom)this.parent.getScene().getTGAtom()).setUpdateMode(TGAtom.GENERIC);
    }

    public void nextFrame() {
        ++this.currframe;
        if (this.currframe >= this.frames.size()) {
            this.currframe = 0;
        }
        this.setFrame(this.currframe);
    }

    public void previousFrame() {
        --this.currframe;
        if (this.currframe < 0) {
            this.currframe = this.frames.size() - 1;
        }
        this.setFrame(this.currframe);
    }

    public void firstFrame() {
        this.currframe = 0;
        this.setFrame(this.currframe);
    }

    public void lastFrame() {
        this.currframe = this.frames.size() - 1;
        this.setFrame(this.currframe);
    }

    public void nextFrame(int skip_) {
        if (skip_ >= this.frames.size()) {
            this.nextFrame();
        }
        this.currframe += skip_;
        if (this.currframe >= this.frames.size()) {
            int amari;
            this.currframe = amari = this.currframe - this.frames.size();
        }
        this.setFrame(this.currframe);
    }

    public void previousFrame(int skip_) {
        logger.debug((Object)"at previousFrame(int skip_)");
        if (skip_ >= this.frames.size()) {
            this.previousFrame();
        }
        this.currframe -= skip_;
        if (this.currframe < 0) {
            this.currframe = this.frames.size() + this.currframe - 1;
        }
        this.setFrame(this.currframe);
    }

    private void updateFrame() {
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    public void setRescaleOnUpdate(boolean rescaleOnUpdate) {
        this.rescaleOnUpdate = rescaleOnUpdate;
    }

    @Override
    public void run() {
        this.batchAnimation();
    }

    public void setImageReciever(ImageReciver imageReciever) {
        this.imageReciever = imageReciever;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void batchAnimation() {
        this.images = new Vector();
        this.parent.doRedraw(false);
        int i = 0;
        while (i < this.numFrames) {
            AtomCoords coords = (AtomCoords)this.frames.get(i);
            this.mCD.setCoords(coords, this.rescaleOnUpdate);
            this.mCD.setFrameNum(i);
            ((TGAtom)this.parent.getScene().getTGAtom()).updateMeasureObjects();
            logger.info((Object)("processing frame no. " + i));
            this.images.addElement(this.createImageFiles(this.baseDir, i));
            i += this.skip;
        }
        AtomCoords coords = (AtomCoords)this.frames.get(0);
        ((TGAtom)this.parent.getScene().getTGAtom()).updateMeasureObjects();
        this.mCD.setCoords(coords, this.rescaleOnUpdate);
        this.mCD.setFrameNum(0);
        this.parent.doRedraw(true);
        this.imageReciever.setImages(this.images);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private String createImageFiles(String baseDir, int currentFrame) {
        String imageDir = String.valueOf(baseDir) + System.getProperty("file.separator") + "imagefiles";
        if (new File(imageDir).mkdir()) {
            logger.info((Object)("created image directory: " + baseDir + System.getProperty("file.separator") + "imagefiles"));
        }
        int numDigits = String.valueOf(this.numFrames).length();
        int numDigitsNow = String.valueOf(currentFrame).length();
        String ext = new String();
        int j = 0;
        while (j < numDigits - numDigitsNow) {
            ext = String.valueOf(ext) + "0";
            ++j;
        }
        ext = String.valueOf(ext) + String.valueOf(currentFrame);
        String fileName = "";
        if (this.batchImageMode == 2) {
            fileName = String.valueOf(imageDir) + System.getProperty("file.separator") + this.prefix + ext + ".jpg";
            try {
                this.parent.export(fileName);
            }
            catch (IOException ioe) {
                logger.error((Object)("failed export to file: " + fileName));
            }
        } else if (this.batchImageMode == 3) {
            fileName = String.valueOf(imageDir) + System.getProperty("file.separator") + this.prefix + ext + ".wrl";
            if (this.vrmlExporter == null) {
                this.vrmlExporter = new VRMLExporter(this.parent);
            }
            this.vrmlExporter.doExport(fileName);
        }
        return new String(fileName);
    }

    public Vector getImages() {
        if (this.images == null) {
            this.batchAnimation();
        }
        return this.images;
    }

    private boolean isCyclic() {
        return this.cyclic;
    }

    class Anim
    implements Runnable {
        Anim() {
        }

        @Override
        public void run() {
            Animater.this.parent.doRedraw(false);
            int i = 0;
            while (i < Animater.this.frames.size()) {
                AtomCoords coords = (AtomCoords)Animater.this.frames.get(i);
                Animater.this.mCD.setCoords(coords, Animater.this.rescaleOnUpdate);
                Animater.this.mCD.setFrameNum(i);
                try {
                    Thread.sleep(Animater.this.frameRate);
                }
                catch (InterruptedException ie) {
                    logger.warn((Object)"failed pause");
                }
                ++i;
            }
            Animater.this.parent.doRedraw(true);
        }
    }
}

