/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/03/27 20:31:58
!  AUTHOR(S): KOGA, Junichiro
!  File : RangeOption.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis.perlscriptexecuters;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

public class RangeOption extends PerlScriptOption {
    private Logger logger = Logger.getLogger(RangeOption.class.getName());

    public RangeOption(String opt) {
        super(opt);
    }

    public String generateOptions() {
        if (minText.getText().trim().length() != 0
                && maxText.getText().trim().length() != 0)
            return "-" + optionName + "=" + minText.getText() + ","
                    + maxText.getText();
        return "";
    }

    private JTextField minText;
    private JTextField maxText;

    public JComponent[] getAssociatedGUI() {

        JPanel pmin = new JPanel();
        pmin.setBorder(new TitledBorder(optionName + "(min)"));
        minText = new JTextField(6);
        pmin.add(minText);

        JPanel pmax = new JPanel();
        pmax.setBorder(new TitledBorder(optionName + "(max)"));
        maxText = new JTextField(6);
        pmax.add(maxText);
        return new JComponent[] { pmin, pmax };
    }

    public String getOptionType() {
        return "range";
    }
}
