/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/05/10, 20:34
!  AUTHOR(S): KOGA, Junichiro
!  File : TSpaceRotChoices.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.ComboBoxChoices;

/**
 * TSPACE``rotation''̑I쐬.
 * 
 * @author
 */
public class TSpaceRotChoices implements ComboBoxChoices {
    private Logger logger = Logger.getLogger(TSpaceRotChoices.class.getName());
    private InputInterface inputInterface;
    private String[] tips;
    private String[] choices;
    private String[] tips_torh;
    private String[] choices_torh;

    /** Creates a new instance of TSpaceRotChoices */
    public TSpaceRotChoices(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
        init();
    }

    private void init() {
        InputStream tspacetxt = TSpaceRotChoices.class
                .getResourceAsStream("/ciss/phase_viewer/primitiveguis/tspace.txt");
        InputStream tspacetxt_trig_hexa = TSpaceRotChoices.class
                .getResourceAsStream("/ciss/phase_viewer/primitiveguis/tspace_trig_hexa.txt");
        Vector tag = new Vector();
        Vector descript = new Vector();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(tspacetxt));
            String line = "";
            while ((line = reader.readLine()) != null) {
                String str = line.trim();
                if (str.startsWith("#")) {
                    continue;
                }
                String[] arr = str.split(",");
                tag.addElement(arr[0].trim());
                if (arr.length >= 2) {
                    descript.addElement(arr[1].trim());
                }
            }
            choices = new String[tag.size()];
            tag.copyInto(choices);
            tips = new String[descript.size()];
            descript.copyInto(tips);

            reader = new BufferedReader(new InputStreamReader(
                    tspacetxt_trig_hexa));
            tag = new Vector();
            descript = new Vector();
            while ((line = reader.readLine()) != null) {
                String str = line.trim();
                if (str.startsWith("#")) {
                    continue;
                }
                String[] arr = str.split(",");
                tag.addElement(arr[0].trim());
                if (arr.length >= 2) {
                    descript.addElement(arr[1].trim());
                }
            }
            choices_torh = new String[tag.size()];
            tag.copyInto(choices_torh);
            tips_torh = new String[descript.size()];
            descript.copyInto(tips_torh);
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            try {
                reader.close();
            } catch (IOException ioe) {
            }
        }
    }

    public Object[] getChoices(String index) {
        return null;
    }

    public String getToolTipTexts(int index) {
        if (!isTrigOrHexa()) {
            if (tips != null && tips.length > index) {
                return tips[index];
            } else {
                return "";
            }
        } else {
            return tips_torh[index];
        }
    }

    public Object[] getChoices(int index) {
        return null;
    }

    public Object[] getChoices() {
        if (!isTrigOrHexa()) {
            return choices;
        } else {
            return choices_torh;
        }
    }

    private boolean isTrigOrHexa() {
        String buff = inputInterface.getCurrentBlock().getFullName();
        InputInterfacePrimitiveEntry entry = inputInterface
                .getInputInterfacePrimitiveEntry("structure.symmetry.tspace.lattice_system");
        logger.debug("current block: " + buff);
        if (entry == null) {
            inputInterface.selectBlock(buff);
            return false;
        }
        boolean ret = entry.getValue().equalsIgnoreCase("trigonal")
                || entry.getValue().equalsIgnoreCase("hexagonal")
                || entry.getValue().equalsIgnoreCase("rhombohedral");
        inputInterface.selectRoot();
        inputInterface.selectBlock(buff);
        logger.debug("current block: "
                + inputInterface.getCurrentBlock().getFullName());
        return ret;
        // return true;
    }
}
