/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/31, 17:53
!  AUTHOR(S): KOGA, Junichiro
!  File : KeyListenerConfig.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.prefs;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropConfigTextField;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * L[Xi[̌ʎ{鑀̕ҏW
 * 
 * @author
 */
public class KeyListenerConfig extends InternalFrameChase {
    private Logger logger = Logger.getLogger(KeyListenerConfig.class.getName());
    private J3DPanel parent;

    /** Creates a new instance of KeyListenerConfig */
    public KeyListenerConfig(J3DPanel parent) {
        super("configure keyboard action", new Dimension(350, 200));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        init();
        setVisible(true);
    }

    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    private void init() {
        PropConfigTextField rot = new PropConfigTextField(7,
                PropConfigTextField.FLOAT, "keylistener_rot", props);
        PropConfigTextField trans = new PropConfigTextField(7,
                PropConfigTextField.FLOAT, "keylistener_trans", props);
        PropConfigTextField zoom = new PropConfigTextField(7,
                PropConfigTextField.FLOAT, "keylistener_zoom", props);
        PropConfigTextField skip = new PropConfigTextField(7,
                PropConfigTextField.INT, "keylistener_frame_skip", props);
        PropConfigTextField atomtransx = new PropConfigTextField(7,
                PropConfigTextField.FLOAT, "keylistener_atomtrans_x", props);
        PropConfigTextField atomtransy = new PropConfigTextField(7,
                PropConfigTextField.FLOAT, "keylistener_atomtrans_y", props);

        JPanel prot = new JPanel();
        prot.setBorder(new TitledBorder("rot. factor"));
        prot.add(rot);

        JPanel ptrans = new JPanel();
        ptrans.setBorder(new TitledBorder("trans. factor"));
        ptrans.add(trans);

        JPanel pzoom = new JPanel();
        pzoom.setBorder(new TitledBorder("zoom factor"));
        pzoom.add(zoom);

        JPanel pskip = new JPanel();
        pskip.setBorder(new TitledBorder("frames to skip"));
        pskip.add(skip);

        JPanel pattransx = new JPanel();
        pattransx.setBorder(new TitledBorder("atom trans x (A)"));
        pattransx.add(atomtransx);
        JPanel pattransy = new JPanel();
        pattransy.setBorder(new TitledBorder("atom trans y (A)"));
        pattransy.add(atomtransy);

        JPanel upperPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        upperPanel.setLayout(new BoxLayout(upperPanel, BoxLayout.X_AXIS));
        lowerPanel.setLayout(new BoxLayout(lowerPanel, BoxLayout.X_AXIS));
        upperPanel.add(prot);
        upperPanel.add(ptrans);
        upperPanel.add(pzoom);

        lowerPanel.add(pskip);
        lowerPanel.add(pattransx);
        lowerPanel.add(pattransy);
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, BoxLayout.Y_AXIS));
        ret.add(upperPanel);
        ret.add(lowerPanel);

        Container container = getContentPane();
        container.setLayout(new BoxLayout(container, BoxLayout.Y_AXIS));

        container.add(ret);

        JButton apply = new JButton("apply");
        JButton dismiss = new JButton("dismiss");

        JPanel btn = new JPanel();
        btn.setLayout(new BoxLayout(btn, BoxLayout.X_AXIS));
        btn.add(apply);
        btn.add(dismiss);
        container.add(btn);

        dismiss.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        apply.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                props.storeProperty();
            }
        });

    }

}
