/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/30, 13:49
!  AUTHOR(S): KOGA, Junichiro
!  File : DefaultFileBrowserNode.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.filebrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

import javax.swing.JPopupMenu;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.MyJMenuItem;

/**
 * ftHg̃t@CuEU[pm[h
 * 
 * @author
 */
public class DefaultFileBrowserNode extends FileBrowserNode {
    private Logger logger = Logger.getLogger(DefaultFileBrowserNode.class
            .getName());

    protected FileBrowserTree tree;

    /**
     * userObjectƂĂ, RemoteFileIuWFNg𗘗pKv. Ƃ͂Ă
     * [Jt@Ĉ݂Ȃt@C̃pXɃCX^X΂ł悢. ܂,
     * ʂFileBrowserTreeŏɏĂ͂
     */
    public DefaultFileBrowserNode(Object userObject) {
        super(userObject);
    }

    public void mousePressed(MouseEvent e, FileBrowserTree tree) {
        if (e.getButton() == MouseEvent.BUTTON3) {
            this.tree = tree;
            showMenu(e);
        }
    }

    protected void showMenu(MouseEvent e) {
        if (e == null) {
            logger.error("MouseEvent is null");
            return;
        }

        JPopupMenu popup = new JPopupMenu();
        MyJMenuItem[] items;

        items = getDefaultMenuItems();

        for (int i = 0; i < items.length; i++) {
            popup.add(items[i]);
        }

        if (e.getComponent() == null) {
            logger.error("e.getComponent() returns null...something is wrong!");
            return;
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    protected MyJMenuItem[] getDefaultMenuItems() {
        MyJMenuItem locdel = new MyJMenuItem("delete", KeyEvent.VK_D);
        MyJMenuItem locchfname = new MyJMenuItem("rename", KeyEvent.VK_C);
        MyJMenuItem locmkdir = new MyJMenuItem("create new dir", KeyEvent.VK_N);
        MyJMenuItem locprops = new MyJMenuItem("property", KeyEvent.VK_P);
        MyJMenuItem locnewfile = new MyJMenuItem("create new file",
                KeyEvent.VK_F);
        MyJMenuItem locedit = new MyJMenuItem("editor", KeyEvent.VK_E);
        MyJMenuItem[] ret = { locchfname, locmkdir, locnewfile, locprops,
                locdel, locedit };

        locdel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tree.deleteSelectedFiles();
            }
        });

        locchfname.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tree.rename();
            }
        });

        locmkdir.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tree.mkdir();
            }
        });

        locprops.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tree.bootFilePropertyViewer();
            }
        });

        locedit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tree.bootProgram(true);
            }
        });

        locnewfile.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tree.createNewFile();
            }
        });

        return ret;
    }

    public void mouseClicked(MouseEvent e, FileBrowserTree tree) {
        if (e.getButton() == MouseEvent.BUTTON1 && e.getClickCount() == 2) {
            tree.bootProgram(false);
        }
    }

}
