/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/30, 16:00
!  AUTHOR(S): KOGA, Junichiro
!  File : PropConfigCheckBox.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;

import org.apache.log4j.Logger;

/**
 * ^Ul̃vpeB[JCheckBox
 * 
 */
public class PropConfigCheckBox extends JCheckBox implements PropConfigGUI {
    private Logger logger = Logger
            .getLogger(PropConfigCheckBox.class.getName());
    private GlobalProperties properties;
    private String key;

    public PropConfigCheckBox(String text, String key,
            GlobalProperties properties) {
        super(text);
        this.key = key;
        this.properties = properties;
        init();
    }

    private void init() {
        load();
        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                save();
            }
        });
    }

    public void save() {
        properties.setProperty(key, String.valueOf(isSelected()));
    }

    public void load() {
        setSelected(new Boolean(properties.getProperty(key)).booleanValue());
    }

}
