/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/19, 18:04
!  AUTHOR(S): KOGA, Junichiro
!  File : ScriptEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.scripting.scripteditor;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.pub.jeditsyntax.BatchFileTokenMarker;
import ciss.phase_viewer.pub.jeditsyntax.JEditTextArea;
import ciss.phase_viewer.pub.jeditsyntax.JavaTokenMarker;
import ciss.phase_viewer.pub.jeditsyntax.ShellScriptTokenMarker;

/**
 * ScriptҏW; eLXg𒼐ڕҏW...
 * 
 * @author
 */
public class ScriptEditor extends JPanel {
    private Logger logger = Logger.getLogger(ScriptEditor.class.getName());
    private String scriptPath;

    /** Creates a new instance of ScriptEditor */
    public ScriptEditor(String scriptPath) {
        this.scriptPath = scriptPath;
        init();
    }

    private JEditTextArea area;

    private void init() {
        removeAll();
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        area = new JEditTextArea();
        area.setPreferredSize(new Dimension(500, 300));
        String lower = scriptPath.toLowerCase();
        if (lower.endsWith(".bsh") || lower.endsWith(".java")) {
            area.setTokenMarker(new JavaTokenMarker());
        } else if (lower.endsWith(".bat")) {
            area.setTokenMarker(new BatchFileTokenMarker());
        } else if (lower.endsWith(".sh")) {
            area.setTokenMarker(new ShellScriptTokenMarker());
        }
        area.setCaretBlinkEnabled(true);
        String text = "";
        File file = new File(scriptPath);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null) {
                text += line + System.getProperty("line.separator");
            }
            area.setText(text);
            reader.close();
        } catch (Exception exc) {
        }
        area.setCaretPosition(0);
        add(area);
    }

    public void reload() {
        init();
    }

    public boolean save() {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(scriptPath));
            String text = area.getText();
            writer.write(text, 0, text.length());
            writer.close();
        } catch (IOException ioe) {
            logger.error("failed write to " + scriptPath);
            return false;
        } finally {
            try {
                writer.close();
            } catch (IOException ioe) {
            }
        }
        return true;
    }
}
