/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InputPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.awt.FlowLayout;

import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class InputPanel extends JPanel {
    JLabel m_tag;
    public JTextField m_value; /* !< ̃NXێJTextFieldIuWFNg */
    public JComboBox m_unit; /* !< ̃NXێJComboBoxIuWFNg */

    public static final int NONE = 0; /* !< PʂȂw肷. */
    public static final int LONGTIME = 1; /*
                                           * !< PHASEvO̎sԂw肷邽߂̒P (day,
                                           * hour,...)w肷.
                                           */
    public static final int TIME = 2; /* !< PHASE̎ (au_time, fs, ... ). */
    public static final int LENGTH = 3; /* !< ̒Pʂw. */
    public static final int ENERGY = 4; /* !< GlM[̒Pʂw. */
    public static final int FORCE = 5; /* !< ͂̒Pʂw. */

    private String[] units_longtime = { "day", "hour", "min", "sec" };
    private String[] units_time = { "au_time", "ns", "fs", };
    private String[] units_length = { "Bohr", "Angstrom", "nm" };
    private String[] units_energy = { "Hartree", "Rydberg", "eV" };
    private String[] units_force = { "Hartree/Bohr", "eV/Angstrom" };

    /**
     * ̃NX񋟂GUI쐬. JTextField͋̓IȒl ͂邽,
     * JComboBox͑ΉPʂҏW邽߂ɔz.
     * 
     * @param tag
     *            ^Cg.
     * @param unit
     *            Pʂ̎.
     * @param textlen
     *            JTextField̃J.
     */
    public InputPanel(String tag, int unit, int textlen) {
        int pwidth;
        if (unit == NONE) {
            pwidth = textlen;
        } else {
            pwidth = textlen + 80;
        }
        // setLayout( new FlowLayout(FlowLayout.CENTER) );
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        setSize(pwidth, 20);
        // m_tag = new JLabel( tag, JLabel.LEFT);
        // m_tag.setPreferredSize( new Dimension(taglen,20));
        // add(m_tag);
        m_value = new JTextField(textlen);
        m_value.setSize(textlen, 20);
        add(m_value);
        if (unit == LONGTIME) {
            m_unit = new JComboBox(units_longtime);
        } else if (unit == TIME) {
            m_unit = new JComboBox(units_time);
        } else if (unit == LENGTH) {
            m_unit = new JComboBox(units_length);
        } else if (unit == ENERGY) {
            m_unit = new JComboBox(units_energy);
        } else if (unit == FORCE) {
            m_unit = new JComboBox(units_force);
        }
        if (unit != NONE) {
            m_unit.setSize(60, 20);
            add(m_unit);
        }
        setBorder(new TitledBorder(tag));
    }

    public InputPanel(String tag, int unit, int textlen, JTextField textfield) {
        int pwidth;
        if (unit == NONE) {
            pwidth = textlen;
        } else {
            pwidth = textlen + 80;
        }
        // setLayout( new FlowLayout(FlowLayout.CENTER) );
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        setSize(pwidth, 20);
        // m_tag = new JLabel( tag, JLabel.LEFT);
        // m_tag.setPreferredSize( new Dimension(taglen,20));
        // add(m_tag);
        // m_value = new JTextField(textlen);

        m_value = textfield;
        m_value.setSize(textlen, 20);
        add(m_value);
        if (unit == LONGTIME) {
            m_unit = new JComboBox(units_longtime);
        } else if (unit == TIME) {
            m_unit = new JComboBox(units_time);
        } else if (unit == LENGTH) {
            m_unit = new JComboBox(units_length);
        } else if (unit == ENERGY) {
            m_unit = new JComboBox(units_energy);
        } else if (unit == FORCE) {
            m_unit = new JComboBox(units_force);
        }
        if (unit != NONE) {
            m_unit.setSize(60, 20);
            add(m_unit);
        }
        setBorder(new TitledBorder(tag));
    }

    public InputPanel(String tag, int unit, int textlen, JTextField textfield,
            boolean flowLayout) {
        int pwidth;
        if (unit == NONE) {
            pwidth = textlen;
        } else {
            pwidth = textlen + 80;
        }
        // setLayout( new FlowLayout(FlowLayout.CENTER) );
        if (flowLayout)
            setLayout(new FlowLayout());
        else
            setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

        setSize(pwidth, 20);
        // m_tag = new JLabel( tag, JLabel.LEFT);
        // m_tag.setPreferredSize( new Dimension(taglen,20));
        // add(m_tag);
        // m_value = new JTextField(textlen);

        m_value = textfield;
        m_value.setSize(textlen, 20);
        add(m_value);
        if (unit == LONGTIME) {
            m_unit = new JComboBox(units_longtime);
        } else if (unit == TIME) {
            m_unit = new JComboBox(units_time);
        } else if (unit == LENGTH) {
            m_unit = new JComboBox(units_length);
        } else if (unit == ENERGY) {
            m_unit = new JComboBox(units_energy);
        } else if (unit == FORCE) {
            m_unit = new JComboBox(units_force);
        }
        if (unit != NONE) {
            m_unit.setSize(60, 20);
            add(m_unit);
        }
        setBorder(new TitledBorder(tag));
    }

    public InputPanel(String tag, int unit, int textlen, boolean flowLayout) {
        int pwidth;
        if (unit == NONE) {
            pwidth = textlen;
        } else {
            pwidth = textlen + 80;
        }
        if (flowLayout) {
            setLayout(new FlowLayout(FlowLayout.CENTER));
        } else {
            setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        }
        setSize(pwidth, 20);
        // m_tag = new JLabel( tag, JLabel.LEFT);
        // m_tag.setPreferredSize( new Dimension(taglen,20));
        // add(m_tag);
        m_value = new JTextField(textlen);
        m_value.setSize(textlen, 20);
        add(m_value);
        if (unit == LONGTIME) {
            m_unit = new JComboBox(units_longtime);
        } else if (unit == TIME) {
            m_unit = new JComboBox(units_time);
        } else if (unit == LENGTH) {
            m_unit = new JComboBox(units_length);
        } else if (unit == ENERGY) {
            m_unit = new JComboBox(units_energy);
        } else if (unit == FORCE) {
            m_unit = new JComboBox(units_force);
        }
        if (unit != NONE) {
            m_unit.setSize(60, 20);
            add(m_unit);
        }
        setBorder(new TitledBorder(tag));
    }

    /**
     * JTextField̒l擾.
     * 
     * @return JTextFieldɕ\Ăl.
     */
    public String getValue() {
        return (String) m_value.getText();
    }

    /**
     * JComboBox̒l擾
     * 
     * @return JComboBox̒l.
     */
    public String getUnit() {
        return (String) m_unit.getSelectedItem();
    }

    /**
     * JTextField̒lݒ肷.
     * 
     * @param str
     *            JTextFieldɕ\l.
     */
    public void setValue(String str) {
        m_value.setText(str);
    }

    /**
     * JComboBox̒lݒ肷.
     * 
     * @param unit
     *            ݒ肵JComboBox̒l.
     */
    public void setUnit(String unit) {
        m_unit.setSelectedItem(unit);
    }

    public JTextField getTextField() {
        return this.m_value;
    }

    public void setTextField(JTextField m_value) {
        this.m_value = m_value;
    }

}
