/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.event;

import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.ConnectEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AIDAObservable {
    private List listeners;
    private Map hash;
    protected boolean isConnected = true;
    protected boolean connectionDidChange = false;
    private ConnectEvent connectEvent = new ConnectEvent(this, true);
    protected boolean isValid = false;
    private boolean isValidAfterNotify = false;
    private EventObject theEvent;

    protected AIDAObservable() {
    }

    protected void setIsValidAfterNotify(boolean value) {
        this.isValidAfterNotify = value;
    }

    public synchronized void addListener(AIDAListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
        if (this.theEvent == null) {
            this.theEvent = this.createEvent();
        }
        if (this.hash == null) {
            this.hash = new HashMap();
        }
        this.hash.put(l, new Boolean(true));
        this.isValid = true;
    }

    public synchronized void removeListener(AIDAListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
        if (this.listeners != null) {
            this.hash.remove(l);
        }
        if (this.listeners.isEmpty()) {
            this.isValid = false;
        }
    }

    public synchronized void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.hash != null) {
            this.hash.clear();
        }
        this.isValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValid(AIDAListener l) {
        boolean fireConnectionEvent = false;
        AIDAObservable aIDAObservable = this;
        synchronized (aIDAObservable) {
            if (this.connectionDidChange) {
                fireConnectionEvent = true;
                this.connectionDidChange = false;
            }
            if (this.listeners != null) {
                this.hash.put(l, new Boolean(true));
                this.isValid = true;
            }
        }
        if (fireConnectionEvent) {
            this.fireStateChanged(this.connectEvent, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValidForAll() {
        boolean fireConnectionEvent = false;
        AIDAObservable aIDAObservable = this;
        synchronized (aIDAObservable) {
            if (this.connectionDidChange) {
                fireConnectionEvent = true;
                this.connectionDidChange = false;
            }
            if (this.listeners != null) {
                int i = this.listeners.size();
                while (i-- > 0) {
                    AIDAListener l = (AIDAListener)this.listeners.get(i);
                    this.hash.put(l, new Boolean(true));
                }
                this.isValid = true;
            }
        }
        if (fireConnectionEvent) {
            this.fireStateChanged(this.connectEvent, false);
        }
    }

    protected EventObject createEvent() {
        return new EventObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean isConnected) {
        boolean fireConnectionEvent = false;
        AIDAObservable aIDAObservable = this;
        synchronized (aIDAObservable) {
            this.isConnected = isConnected;
            this.connectEvent.setConnected(isConnected);
            if (this.isValid) {
                fireConnectionEvent = true;
                this.connectionDidChange = false;
            } else {
                this.connectionDidChange = true;
            }
        }
        if (fireConnectionEvent) {
            this.fireStateChanged(this.connectEvent, false);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected void fireStateChanged() {
        this.fireStateChanged(this.theEvent);
    }

    protected synchronized void fireStateChanged(EventObject event) {
        this.fireStateChanged(event, true);
    }

    protected synchronized void fireStateChanged(EventObject event, boolean checkValid) {
        this.isValid = this.isValidAfterNotify;
        if (this.listeners != null) {
            int i = this.listeners.size();
            while (i-- > 0) {
                AIDAListener l = (AIDAListener)this.listeners.get(i);
                boolean listenerValid = (Boolean)this.hash.get(l);
                if (!checkValid) {
                    l.stateChanged(event);
                    continue;
                }
                if (!listenerValid) continue;
                l.stateChanged(event);
                this.hash.put(l, new Boolean(this.isValidAfterNotify));
            }
        }
    }
}

