/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.textviewer;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import org.apache.log4j.Logger;

public class HelpViewer
extends InternalFrameChase {
    private static Logger logger = Logger.getLogger(HelpViewer.class.getName());
    private Container container = this.getContentPane();
    private String helpPath;
    private JEditorPane pane;
    private JButton backButton;

    public HelpViewer() {
        super("help", true, true, true, true, new Dimension(800, 600));
        String help = PropertiesManager.getGlobalProperties(0).getProperty("htmlhelpdir");
        String helphs = System.getProperty("pviewer.home");
        if (help != null && help.trim().length() != 0) {
            helphs = helphs + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + "help.jar";
            logger.debug("helpset: " + helphs);
        }
        if (!new File(helphs).exists()) {
            logger.error("couldn't find helpset.");
            this.dispose();
            return;
        }
        this.helpPath = helphs;
        URL url = null;
        HelpSet set = null;
        try {
            url = new URL("jar:file:" + this.helpPath + "!/help.hs");
            set = new HelpSet(HelpViewer.class.getClassLoader(), url);
        }
        catch (Exception exc) {
            // empty catch block
        }
        JHelp jhelp = new JHelp(set);
        this.container.add(jhelp);
    }
}

