/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElement;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class LightObject
extends SceneGraphElement {
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private BranchGroup bg;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);

    public int getType() {
        return 6;
    }

    public void create() {
        if (this.bg != null) {
            this.bg.detach();
        }
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        String[] light_type = new String[]{this.gp.getProperty("light1_type"), this.gp.getProperty("light2_type"), this.gp.getProperty("light3_type"), this.gp.getProperty("light4_type"), this.gp.getProperty("light5_type")};
        for (int i = 0; i < 5; ++i) {
            Color3f co;
            String[] col;
            AmbientLight light;
            if (light_type[i] == null || light_type[i].equals("off")) continue;
            String light_prefix = "light" + String.valueOf(i + 1) + "_";
            if (light_type[i].equals("directional")) {
                light = null;
                try {
                    String[] dire = this.gp.getProperty(light_prefix + "direction").split(",");
                    Vector3f dir = new Vector3f(Float.parseFloat(dire[0]), Float.parseFloat(dire[1]), Float.parseFloat(dire[2]));
                    String[] col2 = this.gp.getProperty(light_prefix + "color").split(",");
                    Color3f co2 = new Color3f(Float.parseFloat(col2[0]), Float.parseFloat(col2[1]), Float.parseFloat(col2[2]));
                    light = new DirectionalLight(co2, dir);
                    light.setInfluencingBounds((Bounds)this.bounds);
                }
                catch (Exception exc) {
                    // empty catch block
                }
                if (light == null) continue;
                this.bg.addChild(light);
                continue;
            }
            if (light_type[i].equals("ambient")) {
                light = null;
                try {
                    col = this.gp.getProperty(light_prefix + "color").split(",");
                    co = new Color3f(Float.parseFloat(col[0]), Float.parseFloat(col[1]), Float.parseFloat(col[2]));
                    light = new AmbientLight(co);
                    light.setInfluencingBounds((Bounds)this.bounds);
                    this.bg.addChild((Node)light);
                }
                catch (Exception exc) {}
                continue;
            }
            if (!light_type[i].equals("point")) continue;
            light = null;
            try {
                col = this.gp.getProperty(light_prefix + "color").split(",");
                co = new Color3f(Float.parseFloat(col[0]), Float.parseFloat(col[1]), Float.parseFloat(col[2]));
                String[] pos = this.gp.getProperty(light_prefix + "position").split(",");
                light = new PointLight(co, new Point3f(Float.parseFloat(pos[0]), Float.parseFloat(pos[1]), Float.parseFloat(pos[2])), new Point3f(1.0f, 0.0f, 0.0f));
                light.setInfluencingBounds((Bounds)this.bounds);
                this.bg.addChild((Node)light);
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        this.addChild((Node)this.bg);
    }

    public void recreate() {
        this.create();
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
    }
}

