/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptmanipulator;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.filebrowser.DefaultFileBrowserPanel;
import ciss.phase_viewer.filebrowser.FileBrowserEvent;
import ciss.phase_viewer.filebrowser.FileBrowserTree;
import ciss.phase_viewer.filebrowser.FileBrowserTreeListener;
import ciss.phase_viewer.scripting.ScriptDescriptionPanel;
import ciss.phase_viewer.scripting.scriptmanipulator.ScriptList;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ScriptBrowser
extends JPanel
implements FileBrowserTreeListener,
MouseListener {
    private Logger logger = Logger.getLogger(ScriptBrowser.class.getName());
    private FileBrowserTree tree;
    private String dotchase = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer";
    private String scriptDir = this.dotchase + System.getProperty("file.separator") + "scripts";
    private String scriptDirOrig = System.getProperty("pviewer.home") + System.getProperty("file.separator") + "scripts";
    DefaultFileBrowserPanel browser;
    private ScriptList scriptList;
    private FileBrowserTree fbtree;
    private ScriptDescriptionPanel descriptionPanel;
    private JSplitPane split;

    public ScriptBrowser(String inidir, ScriptList scriptList) {
        if (!new File(this.scriptDir).exists()) {
            Utils.copyDir(new File(this.scriptDirOrig), new File(this.dotchase));
        }
        this.scriptList = scriptList;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.browser = new DefaultFileBrowserPanel(this.scriptDir + System.getProperty("file.separator") + inidir, "ciss.phase_viewer.scripting.scriptmanipulator.ScriptBrowserNode");
        this.browser.addFileBrowserTreeListener(this);
        p.add(this.browser);
        p.setBorder(new TitledBorder("script files"));
        this.fbtree = this.browser.getFileBrowserTree();
        JTree tree = this.fbtree.getTree();
        tree.addMouseListener(this);
        this.setLayout(new GridLayout());
        this.descriptionPanel = new ScriptDescriptionPanel();
        this.split = new JSplitPane(1, true, p, this.descriptionPanel);
        this.split.setResizeWeight(0.5);
        this.add(this.split);
        this.setBorder(new TitledBorder("select script"));
        this.mousePressed(null);
    }

    public void adjust() {
        this.split.setDividerLocation(0.5);
    }

    public void directoryHasChanged(FileBrowserEvent e) {
        this.adjust();
        String[] paths = this.fbtree.getSelectedPaths();
        this.descriptionPanel.setScriptFile(paths[0]);
    }

    public String[] getSelectedPaths() {
        return this.browser.getSelectedPaths();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.adjust();
        String[] paths = this.fbtree.getSelectedPaths();
        this.descriptionPanel.setScriptFile(paths[0]);
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

