/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scripteditor;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceData;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.scripting.ScriptDescriptionPanel;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditor;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorCaller;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class ScriptEditorPanel
extends JPanel {
    private Logger logger = Logger.getLogger(ScriptEditorPanel.class.getName());
    private String script;
    private ScriptEditorCaller parentFrame;
    private InputInterface inputInterface;
    private boolean hasEditor = true;
    private boolean hasDescription = true;
    private JTabbedPane tabbedPane;
    private ScriptEditor scriptEditor;
    private ScriptDescriptionPanel descriptionPanel;

    public ScriptEditorPanel(ScriptEditorCaller parentFrame) {
        this.parentFrame = parentFrame;
        this.script = parentFrame.getScriptPath();
        this.init();
    }

    public ScriptEditorPanel(ScriptEditorCaller parentFrame, boolean hasEditor, boolean hasDescription) {
        this.parentFrame = parentFrame;
        this.script = parentFrame.getScriptPath();
        this.hasEditor = hasEditor;
        this.hasDescription = hasDescription;
        this.init();
    }

    public void save() {
        if (this.tabbedPane != null) {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                ScriptUtils.saveScript(this.script, this.inputInterface, this.descriptionPanel.getScriptDescriptionText());
                this.scriptEditor.reload();
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.scriptEditor.save();
                this.inputInterface = ScriptUtils.getInputInterfaceFrom(this.script);
                if (this.inputInterface == null) {
                    return;
                }
                this.tabbedPane.removeTabAt(0);
                this.tabbedPane.insertTab("edit script input", null, this.createInputEditors(), "", 0);
            }
        } else {
            ScriptUtils.saveScript(this.script, this.inputInterface, this.descriptionPanel.getScriptDescriptionText());
        }
        if (this.scriptEditor != null) {
            this.scriptEditor.reload();
        }
    }

    private void init() {
        this.inputInterface = ScriptUtils.getInputInterfaceFrom(this.script);
        if (this.inputInterface == null) {
            return;
        }
        this.createGUI();
        this.revalidate();
    }

    private void createGUI() {
        if (this.hasEditor) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setTabLayoutPolicy(1);
            this.tabbedPane.addTab("edit script input", this.createInputEditors());
            this.scriptEditor = new ScriptEditor(this.script);
            this.tabbedPane.addTab("edit the script itself", this.scriptEditor);
            this.add(this.tabbedPane);
        } else {
            this.add(this.createInputEditors());
        }
    }

    private JPanel createInputEditors() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.descriptionPanel = new ScriptDescriptionPanel(this.script);
        this.descriptionPanel.setEditable(true);
        String[] blocks = this.inputInterface.getBlockTags();
        if (blocks == null || blocks.length == 0) {
            JPanel noeditableInput = new JPanel();
            JLabel lab = new JLabel("no editable input found");
            Font curfont = lab.getFont();
            lab.setFont(new Font(curfont.getName(), curfont.getStyle(), 18));
            noeditableInput.add(lab);
            panel.add(noeditableInput);
            if (this.hasDescription) {
                panel.add(this.descriptionPanel);
            }
            return panel;
        }
        JComponent comp = this.createPane();
        panel.add(comp);
        if (this.hasDescription) {
            panel.add(this.descriptionPanel);
        }
        return panel;
    }

    private JComponent createPane() {
        JTabbedPane pane = new JTabbedPane();
        pane.setTabLayoutPolicy(1);
        InputInterfaceData[] data = this.inputInterface.getAllEntries();
        JPanel bpanel = new JPanel();
        String blockName = this.inputInterface.getCurrentBlock().getName();
        if (!blockName.equals("root block") && this.inputInterface.getPrimitiveEntryCount() != 0) {
            pane.addTab(blockName, bpanel);
            pane.revalidate();
        }
        for (int i = 0; i < data.length; ++i) {
            String name = data[i].getName();
            if (data[i].isBlock()) {
                this.logger.debug("current block: " + blockName);
                this.logger.debug("name: " + name);
                this.inputInterface.selectBlock(name);
                JComponent comp = this.createPane();
                if (comp == null) continue;
                pane.addTab(name, comp);
                pane.revalidate();
                continue;
            }
            if (!(data[i] instanceof InputInterfacePrimitiveEntry)) continue;
            bpanel.add(this.createPrimitiveGUI((InputInterfacePrimitiveEntry)data[i]));
        }
        JComponent component = null;
        component = this.inputInterface.getBlockCount() != 0 ? pane : bpanel;
        this.inputInterface.selectParentBlock();
        return component;
    }

    private JPanel createPrimitiveGUI(InputInterfacePrimitiveEntry entry) {
        JPanel ptf = new JPanel();
        if (entry == null) {
            return null;
        }
        ptf.setBorder(new TitledBorder(entry.getName()));
        String[] array = null;
        array = entry.getValue().trim().length() == 0 ? new String[]{""} : entry.getValue().trim().split(":");
        if (array.length <= 1 || array[1].trim().equalsIgnoreCase("textfield")) {
            JTextField tf = new JTextField(8);
            tf.setText(array[0]);
            tf.addCaretListener(new CaretListenerScriptEditor(entry.getFullName()));
            ptf.add(tf);
            return ptf;
        }
        if (array.length >= 3 && array[1].trim().equalsIgnoreCase("combo")) {
            String[] choices = array[2].toLowerCase().split("_or_");
            JComboBox<String> combo = new JComboBox<String>(choices);
            combo.setSelectedItem(array[0]);
            combo.addActionListener(new ActionListenerScriptEditor(entry.getFullName()));
            ptf.add(combo);
            return ptf;
        }
        if (array.length >= 3 && array[1].trim().equalsIgnoreCase("btn")) {
            String label = array[0];
            String evalscript = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "scripts" + System.getProperty("file.separator") + array[2];
            JButton btn = new JButton(label);
            btn.addActionListener(new BtnActionListener(evalscript));
            ptf.add(btn);
        }
        return ptf;
    }

    private String getBlockName(String tag) {
        String[] foo = tag.split("\\.");
        if (foo == null || foo.length <= 1) {
            return "";
        }
        String ret = foo[0];
        for (int i = 1; i < foo.length - 1; ++i) {
            ret = ret + "." + foo[i];
        }
        return ret;
    }

    private String getEntryName(String tag) {
        String[] foo = tag.split("\\.");
        if (foo == null || foo.length == 0) {
            return "";
        }
        return foo[foo.length - 1];
    }

    class ActionListenerScriptEditor
    implements ActionListener {
        private String tag;
        private String blockName;
        private String entryName;

        ActionListenerScriptEditor(String tag) {
            this.tag = tag;
            this.blockName = ScriptEditorPanel.this.getBlockName(tag);
            this.entryName = ScriptEditorPanel.this.getEntryName(tag);
            ScriptEditorPanel.this.logger.debug("combobox_scripteditor, tag: " + tag);
        }

        public void actionPerformed(ActionEvent e) {
            this.doUpdate(e);
        }

        private void doUpdate(ActionEvent e) {
            ScriptEditorPanel.this.inputInterface.selectBlock(this.blockName);
            InputInterfacePrimitiveEntry entry = ScriptEditorPanel.this.inputInterface.getPrimitiveEntry(this.entryName);
            JComboBox box = (JComboBox)e.getSource();
            String val = box.getSelectedItem().toString();
            String append = box.getItemAt(0).toString();
            for (int i = 1; i < box.getItemCount(); ++i) {
                append = append + "_or_" + box.getItemAt(i);
            }
            val = val + ":combo:" + append;
            entry.setValue(val);
        }
    }

    class CaretListenerScriptEditor
    implements CaretListener {
        private String tag;
        private String blockName;
        private String entryName;

        CaretListenerScriptEditor(String tag) {
            this.tag = tag;
            this.blockName = ScriptEditorPanel.this.getBlockName(tag);
            this.entryName = ScriptEditorPanel.this.getEntryName(tag);
            ScriptEditorPanel.this.logger.debug("textfield_scripteditor, tag: " + tag);
        }

        public void caretUpdate(CaretEvent e) {
            this.doUpdate(e);
        }

        private void doUpdate(CaretEvent e) {
            ScriptEditorPanel.this.inputInterface.selectBlock(this.blockName);
            InputInterfacePrimitiveEntry entry = ScriptEditorPanel.this.inputInterface.getPrimitiveEntry(this.entryName);
            JTextField textfield = (JTextField)e.getSource();
            String val = textfield.getText();
            ScriptEditorPanel.this.logger.debug("blockName: " + this.blockName + " entryName: " + this.entryName + " val: " + val);
            entry.setValue(val);
        }
    }

    class BtnActionListener
    implements ActionListener {
        private String evalscript;

        BtnActionListener(String evalscript) {
            this.evalscript = evalscript;
        }

        public void actionPerformed(ActionEvent ae) {
            ScriptUtils.runScript(this.evalscript, ScriptEditorPanel.this.parentFrame.getObjects());
        }
    }
}

